<?php
/**
 * API de Debug - Mostra thresholds configurados
 * Use para verificar se os thresholds estão sendo carregados corretamente
 */

header('Content-Type: text/html; charset=utf-8');

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/thresholds.php';

try {
    $thresholds = new ModerationThresholds();
    $allThresholds = $thresholds->getAllThresholds();
    $loadedThresholds = $thresholds->loadThresholds();
    
    echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Debug Thresholds</title>";
    echo "<style>body{font-family:Arial;padding:20px;} table{border-collapse:collapse;width:100%;} th,td{border:1px solid #ddd;padding:8px;text-align:left;} th{background-color:#4CAF50;color:white;}</style>";
    echo "</head><body>";
    echo "<h1>Debug de Thresholds</h1>";
    
    echo "<h2>Todos os Thresholds no Banco:</h2>";
    echo "<table><tr><th>Categoria</th><th>Threshold</th><th>Habilitado</th><th>Descrição</th></tr>";
    foreach ($allThresholds as $t) {
        $enabled = $t['enabled'] ? 'SIM' : 'NÃO';
        $color = $t['enabled'] ? 'green' : 'red';
        echo "<tr><td>{$t['category']}</td><td>" . ($t['threshold'] * 100) . "%</td><td style='color:$color'>$enabled</td><td>{$t['description']}</td></tr>";
    }
    echo "</table>";
    
    echo "<h2>Thresholds Carregados (apenas habilitados):</h2>";
    echo "<table><tr><th>Categoria</th><th>Threshold</th></tr>";
    foreach ($loadedThresholds as $cat => $val) {
        echo "<tr><td>$cat</td><td>" . ($val * 100) . "%</td></tr>";
    }
    echo "</table>";
    
    echo "<h2>Análise do Comentário 'arrombado':</h2>";
    echo "<table><tr><th>Categoria</th><th>Pontuação</th><th>Threshold</th><th>Detectado?</th></tr>";
    
    $testScores = [
        'violence' => 0.0710,
        'illicit' => 0.0392,
        'sexual' => 0.0196
    ];
    
    foreach ($testScores as $cat => $score) {
        $scorePercent = $score * 100;
        if (isset($loadedThresholds[$cat])) {
            $threshold = $loadedThresholds[$cat];
            $thresholdPercent = $threshold * 100;
            $detected = $score >= $threshold;
            $detectedText = $detected ? 'SIM' : 'NÃO';
            $color = $detected ? 'red' : 'green';
            echo "<tr><td>$cat</td><td>$scorePercent%</td><td>$thresholdPercent%</td><td style='color:$color;font-weight:bold'>$detectedText</td></tr>";
        } else {
            echo "<tr><td>$cat</td><td>$scorePercent%</td><td style='color:red'>NÃO CONFIGURADO</td><td style='color:orange'>Usa valor da API</td></tr>";
        }
    }
    echo "</table>";
    
    echo "<p><strong>Conclusão:</strong> Para detectar essas pontuações, você precisa diminuir os thresholds para valores menores que as pontuações (ex: 0.05 = 5%).</p>";
    
    echo "</body></html>";

} catch (Exception $e) {
    echo "<h1>Erro</h1><p>" . htmlspecialchars($e->getMessage()) . "</p>";
}

