<?php
/**
 * Configuração da API OpenAI
 */

// Defina sua chave da API OpenAI aqui
// Você pode criar um arquivo .env ou definir diretamente
define('OPENAI_API_KEY', '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'); // COLOQUE SUA CHAVE AQUI
define('OPENAI_API_URL', 'https://api.openai.com/v1/moderations');
define('OPENAI_MODEL', 'omni-moderation-latest');

class OpenAIModeration {
    private $apiKey;
    private $apiUrl;
    private $model;

    public function __construct() {
        $this->apiKey = OPENAI_API_KEY;
        $this->apiUrl = OPENAI_API_URL;
        $this->model = OPENAI_MODEL;

        if (empty($this->apiKey)) {
            throw new Exception("Chave da API OpenAI não configurada. Configure em config/openai.php");
        }
    }

    /**
     * Modera um ou múltiplos textos
     * @param string|array $input Texto único ou array de textos
     * @param int $maxRetries Número máximo de tentativas
     * @return array Resposta da API
     */
    public function moderate($input, $maxRetries = 3) {
        $data = [
            'input' => $input,
            'model' => $this->model
        ];

        $attempt = 0;
        $lastError = null;

        while ($attempt < $maxRetries) {
            $ch = curl_init($this->apiUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $this->apiKey
            ]);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);

            // Configurar para capturar headers
            $headers = [];
            curl_setopt($ch, CURLOPT_HEADERFUNCTION, function($curl, $header) use (&$headers) {
                $len = strlen($header);
                $header = explode(':', $header, 2);
                if (count($header) < 2) return $len;
                $headers[strtolower(trim($header[0]))] = trim($header[1]);
                return $len;
            });

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            curl_close($ch);
            
            $body = $response; // curl_exec já retorna apenas o body quando não configurado para incluir headers

            if ($error) {
                $lastError = "Erro cURL: " . $error;
                $attempt++;
                if ($attempt < $maxRetries) {
                    sleep(pow(2, $attempt)); // Backoff exponencial
                    continue;
                }
                throw new Exception($lastError);
            }

            // Sucesso
            if ($httpCode === 200) {
                return json_decode($body, true);
            }

            // Erro 429 - Too Many Requests (retry com backoff)
            if ($httpCode === 429) {
                $errorData = json_decode($body, true);
                $errorMessage = $errorData['error']['message'] ?? "Too Many Requests";
                
                // Tentar extrair tempo de espera dos headers
                $retryAfter = isset($headers['retry-after']) ? intval($headers['retry-after']) : 0;
                if ($retryAfter > 0) {
                    $waitTime = $retryAfter;
                } else {
                    // Backoff exponencial: 2^attempt segundos
                    $waitTime = pow(2, $attempt);
                }

                $attempt++;
                if ($attempt < $maxRetries) {
                    // Aguardar antes de tentar novamente
                    sleep(min($waitTime, 60)); // Máximo de 60 segundos
                    continue;
                }
                
                throw new Exception("Erro da API OpenAI (429): $errorMessage. Tente novamente em alguns minutos.");
            }

            // Outros erros HTTP
            $errorData = json_decode($body, true);
            $errorMessage = $errorData['error']['message'] ?? "Erro desconhecido";
            
            // Alguns erros podem ser retentados
            if (in_array($httpCode, [500, 502, 503, 504]) && $attempt < $maxRetries - 1) {
                $attempt++;
                sleep(pow(2, $attempt));
                continue;
            }
            
            throw new Exception("Erro da API OpenAI ($httpCode): " . $errorMessage);
        }

        throw new Exception("Falha após $maxRetries tentativas: " . ($lastError ?? "Erro desconhecido"));
    }


    /**
     * Processa resultado da moderação e retorna dados formatados
     * @param array $apiResponse Resposta da API
     * @param string|int $inputIndex Índice do input (para múltiplos inputs)
     * @return array Dados formatados
     */
    public function processResult($apiResponse, $inputIndex = 0) {
        if (!isset($apiResponse['results'][$inputIndex])) {
            throw new Exception("Índice de resultado inválido");
        }

        $result = $apiResponse['results'][$inputIndex];
        
        return [
            'flagged' => $result['flagged'] ?? false,
            'categories' => $result['categories'] ?? [],
            'category_scores' => $result['category_scores'] ?? [],
            'id' => $apiResponse['id'] ?? null
        ];
    }

    /**
     * Retorna todas as categorias disponíveis
     * @return array Lista de categorias
     */
    public static function getCategories() {
        return [
            'hate' => 'Ódio',
            'hate/threatening' => 'Ódio/Ameaçador',
            'harassment' => 'Assédio',
            'harassment/threatening' => 'Assédio/Ameaçador',
            'self-harm' => 'Autolesão',
            'self-harm/intent' => 'Autolesão/Intenção',
            'self-harm/instructions' => 'Autolesão/Instruções',
            'sexual' => 'Sexual',
            'sexual/minors' => 'Sexual/Menores',
            'violence' => 'Violência',
            'violence/graphic' => 'Violência/Gráfico',
            'illicit' => 'Ilícito',
            'illicit/violent' => 'Ilícito/Violento'
        ];
    }
}

