<?php
// Página simples para acessar a configuração da IA
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuração da IA</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 20px; 
            background-color: #f5f5f5;
            text-align: center;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 { color: #333; }
        .btn {
            background: #007bff;
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 18px;
            text-decoration: none;
            display: inline-block;
            margin: 10px;
        }
        .btn:hover { background: #0056b3; }
        .btn-success { background: #28a745; }
        .btn-success:hover { background: #1e7e34; }
        .info {
            background: #e7f3ff;
            padding: 20px;
            border-radius: 5px;
            margin: 20px 0;
            border: 1px solid #b3d9ff;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🤖 Configuração da IA</h1>
        
        <div class="info">
            <h3>📊 O que você pode configurar:</h3>
            <ul style="text-align: left;">
                <li><strong>Thresholds da IA:</strong> Sensibilidade para detectar problemas</li>
                <li><strong>Palavras-chave:</strong> Palavras positivas e negativas para análise</li>
                <li><strong>Timeouts:</strong> Tempos de resposta da API</li>
                <li><strong>Teste em tempo real:</strong> Teste suas configurações</li>
            </ul>
        </div>
        
        <a href="IA/thresholds.php" class="btn btn-success">⚙️ Abrir Configuração de Thresholds</a>
        <a href="IA/dashboard.php" class="btn">📊 Dashboard</a>
        
        <div class="info">
            <h3>🔧 Sistema de Moderação:</h3>
            <p>O sistema agora usa <strong>OpenAI API</strong> para moderação de comentários.</p>
            <p>As configurações de thresholds estão disponíveis em <code>IA/thresholds.php</code></p>
            <p>Para mais informações, acesse o dashboard em <code>IA/dashboard.php</code></p>
        </div>
        
        <a href="index.php" class="btn">← Voltar ao Sistema</a>
    </div>
</body>
</html>
