<?php
require_once 'config.php';

$errors = [];
$success = false;
$record = null;

// Verificar se o ID foi fornecido
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: index.php");
    exit;
}

$id = (int)$_GET['id'];

// Processar o formulário quando enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validar e obter dados do formulário
    $maquina = trim($_POST['maquina'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $profile = trim($_POST['profile'] ?? '');
    $orderid = !empty($_POST['orderid']) ? (int)$_POST['orderid'] : null;
    $link = trim($_POST['link'] ?? '');
    $comment = trim($_POST['comment'] ?? '');
    $status = trim($_POST['status'] ?? '');
    
    // Validações
    if (empty($maquina)) {
        $errors[] = "O campo Máquina é obrigatório";
    }
    
    if (empty($username)) {
        $errors[] = "O campo Usuário é obrigatório";
    }
    
    if (empty($profile)) {
        $errors[] = "O campo Perfil é obrigatório";
    }
    
    if (empty($link)) {
        $errors[] = "O campo Link é obrigatório";
    }
    
    if (empty($comment)) {
        $errors[] = "O campo Comentário é obrigatório";
    }
    
    // Se não houver erros, atualizar no banco de dados
    if (empty($errors)) {
        // Preparar a consulta SQL
        $sql = "UPDATE history SET maquina = ?, username = ?, profile = ?, orderid = ?, link = ?, comment = ?, status = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssisssi", $maquina, $username, $profile, $orderid, $link, $comment, $status, $id);
        
        // Executar a consulta
        if ($stmt->execute()) {
            $success = true;
        } else {
            $errors[] = "Erro ao atualizar o registro: " . $conn->error;
        }
    }
}

// Consultar o registro para exibir no formulário
$sql = "SELECT * FROM history WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

// Verificar se o registro existe
if ($result->num_rows === 0) {
    header("Location: index.php");
    exit;
}

$record = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Comentários</title>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <h1 class="header-title">
                    <i class="fas fa-edit"></i>Editar Registro
                </h1>
                <a href="index.php" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left"></i>Voltar
                </a>
            </div>
        </div>
    </header>

    <main class="page-container">
        <?php if ($success): ?>
            <div class="alert alert-success alert-dismissible">
                <i class="fas fa-check-circle me-2"></i>Registro atualizado com sucesso!
                <a href="visualizar.php?id=<?php echo $id; ?>" class="text-success">Ver registro</a> ou 
                <a href="index.php" class="text-success">voltar à lista</a>
                <button type="button" class="btn-close" onclick="this.parentElement.style.display='none';" aria-label="Fechar"></button>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($errors)): ?>
            <div class="alert alert-danger alert-dismissible">
                <i class="fas fa-exclamation-circle me-2"></i>
                <strong>Ocorreram os seguintes erros:</strong>
                <ul class="mb-0 mt-2">
                    <?php foreach ($errors as $error): ?>
                        <li><?php echo $error; ?></li>
                    <?php endforeach; ?>
                </ul>
                <button type="button" class="btn-close" onclick="this.parentElement.style.display='none';" aria-label="Fechar"></button>
            </div>
        <?php endif; ?>
        
        <section class="card">
            <div class="card-header">
                <h2 class="card-title">Registro #<?php echo $record['id']; ?></h2>
            </div>
            <div class="card-body">
                <form method="POST" action="" id="editForm">
                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label for="maquina" class="form-label">Máquina *</label>
                                <input type="text" class="form-control" id="maquina" name="maquina" required 
                                       value="<?php echo htmlspecialchars($_POST['maquina'] ?? $record['maquina']); ?>">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label for="username" class="form-label">Usuário *</label>
                                <input type="text" class="form-control" id="username" name="username" required 
                                       value="<?php echo htmlspecialchars($_POST['username'] ?? $record['username']); ?>">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label for="profile" class="form-label">Perfil *</label>
                                <input type="text" class="form-control" id="profile" name="profile" required 
                                       value="<?php echo htmlspecialchars($_POST['profile'] ?? $record['profile']); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label for="orderid" class="form-label">Order ID</label>
                                <input type="number" class="form-control" id="orderid" name="orderid" 
                                       value="<?php echo htmlspecialchars($_POST['orderid'] ?? $record['orderid']); ?>">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label for="data_acao" class="form-label">Data/Hora</label>
                                <input type="text" class="form-control" id="data_acao" readonly 
                                       value="<?php echo date('d/m/Y H:i:s', strtotime($record['data_acao'])); ?>">
                                <small class="text-muted">Este campo não pode ser editado</small>
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="" <?php echo empty($record['status']) ? 'selected' : ''; ?>>Selecione um status</option>
                                    <option value="Completo" <?php echo (strtolower($record['status']) == 'completo') ? 'selected' : ''; ?>>Completo</option>
                                    <option value="Erro" <?php echo (strtolower($record['status']) == 'erro') ? 'selected' : ''; ?>>Erro</option>
                                    <option value="Pendente" <?php echo (strtolower($record['status']) == 'pendente') ? 'selected' : ''; ?>>Pendente</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="link" class="form-label">Link *</label>
                        <input type="url" class="form-control" id="link" name="link" required 
                               value="<?php echo htmlspecialchars($_POST['link'] ?? $record['link']); ?>">
                    </div>
                    
                    <div class="form-group">
                        <label for="comment" class="form-label">Comentário *</label>
                        <textarea class="form-control" id="comment" name="comment" rows="5" required><?php echo htmlspecialchars($_POST['comment'] ?? $record['comment']); ?></textarea>
                    </div>
                </form>
            </div>
            <div class="card-footer d-flex justify-content-between">
                <a href="visualizar.php?id=<?php echo $id; ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i>Cancelar
                </a>
                <button type="submit" form="editForm" class="btn btn-primary">
                    <i class="fas fa-save"></i>Salvar Alterações
                </button>
            </div>
        </section>
    </main>

    <footer class="text-center mt-4 mb-4 text-muted">
        <small>&copy; <?php echo date('Y'); ?> - Sistema de Histórico</small>
    </footer>
</body>
</html> 