<?php
// Página simples para acessar a configuração da IA
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuração da IA</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 20px; 
            background-color: #f5f5f5;
            text-align: center;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 { color: #333; }
        .btn {
            background: #007bff;
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 18px;
            text-decoration: none;
            display: inline-block;
            margin: 10px;
        }
        .btn:hover { background: #0056b3; }
        .btn-success { background: #28a745; }
        .btn-success:hover { background: #1e7e34; }
        .info {
            background: #e7f3ff;
            padding: 20px;
            border-radius: 5px;
            margin: 20px 0;
            border: 1px solid #b3d9ff;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🤖 Configuração da IA</h1>
        
        <div class="info">
            <h3>📊 O que você pode configurar:</h3>
            <ul style="text-align: left;">
                <li><strong>Thresholds da IA:</strong> Sensibilidade para detectar problemas</li>
                <li><strong>Palavras-chave:</strong> Palavras positivas e negativas para análise</li>
                <li><strong>Timeouts:</strong> Tempos de resposta da API</li>
                <li><strong>Teste em tempo real:</strong> Teste suas configurações</li>
            </ul>
        </div>
        
        <a href="admin_ia.php" class="btn btn-success">⚙️ Abrir Configuração</a>
        
        <div class="info">
            <h3>🔧 Configurações Atuais:</h3>
            <?php
            require_once 'config_ia.php';
            echo "<p><strong>Thresholds:</strong> " . implode(', ', array_map(function($k, $v) { return "$k: $v"; }, array_keys($AI_THRESHOLDS), $AI_THRESHOLDS)) . "</p>";
            echo "<p><strong>Palavras negativas:</strong> " . count($NEGATIVE_KEYWORDS) . " palavras</p>";
            echo "<p><strong>Palavras positivas:</strong> " . count($POSITIVE_KEYWORDS) . " palavras</p>";
            echo "<p><strong>Timeout principal:</strong> " . $TIMEOUT_CONFIG['main_timeout'] . "s</p>";
            ?>
        </div>
        
        <a href="index.php" class="btn">← Voltar ao Sistema</a>
    </div>
</body>
</html>
