<?php
require_once 'config.php';

// Verificar se o ID foi fornecido
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: index.php");
    exit;
}

$id = (int)$_GET['id'];

// Consultar o registro
$sql = "SELECT * FROM history WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

// Verificar se o registro existe
if ($result->num_rows === 0) {
    header("Location: index.php");
    exit;
}

$record = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Comentários</title>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <h1 class="header-title">
                    <i class="fas fa-eye"></i>Visualizar Registro
                </h1>
                <a href="index.php" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left"></i>Voltar
                </a>
            </div>
        </div>
    </header>

    <main class="page-container">
        <section class="card mb-4">
            <div class="card-header">
                <h2 class="card-title">Registro #<?php echo $record['id']; ?></h2>
            </div>
            <div class="card-body">
                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label class="form-label">Máquina</label>
                            <p><?php echo htmlspecialchars($record['maquina']); ?></p>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label class="form-label">Usuário</label>
                            <p><?php echo htmlspecialchars($record['username']); ?></p>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label class="form-label">Perfil</label>
                            <p><?php echo htmlspecialchars($record['profile']); ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label class="form-label">Data/Hora</label>
                            <p><?php echo date('d/m/Y H:i:s', strtotime($record['data_acao'])); ?></p>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label class="form-label">Order ID</label>
                            <p><?php echo $record['orderid'] ? $record['orderid'] : 'N/A'; ?></p>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label class="form-label">Status</label>
                            <?php if (!empty($record['status'])): ?>
                                <?php 
                                    $status_lower = strtolower($record['status']);
                                    $status_class = $status_lower == 'completo' ? 'success' : 
                                        ($status_lower == 'erro' ? 'danger' : 'neutral'); 
                                ?>
                                <p><span class="status-badge status-badge-<?php echo $status_class; ?>"><?php echo htmlspecialchars($record['status']); ?></span></p>
                            <?php else: ?>
                                <p>N/A</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Link</label>
                    <p>
                        <a href="<?php echo htmlspecialchars($record['link']); ?>" target="_blank" class="text-primary">
                            <?php echo htmlspecialchars($record['link']); ?>
                            <i class="fas fa-external-link-alt ms-1" style="font-size: 0.75em;"></i>
                        </a>
                    </p>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Comentário</label>
                    <div class="card" style="background-color: var(--color-surface-variant); box-shadow: none;">
                        <div class="card-body">
                            <?php echo nl2br(htmlspecialchars($record['comment'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex justify-content-between">
                <a href="index.php" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i>Voltar
                </a>
                <a href="editar.php?id=<?php echo $record['id']; ?>" class="btn btn-warning">
                    <i class="fas fa-edit"></i>Editar
                </a>
            </div>
        </section>
    </main>

    <footer class="text-center mt-4 mb-4 text-muted">
        <small>&copy; <?php echo date('Y'); ?> - Sistema de Histórico</small>
    </footer>
</body>
</html> 