-- Tabela para armazenar thresholds customizados por categoria
-- Execute este SQL para adicionar a funcionalidade de thresholds

USE moderacao;

CREATE TABLE IF NOT EXISTS moderation_thresholds (
    id INT AUTO_INCREMENT PRIMARY KEY,
    category_name VARCHAR(100) NOT NULL UNIQUE,
    threshold_value DECIMAL(5,4) DEFAULT 0.5000 COMMENT 'Valor mínimo de pontuação para considerar como detectado (0.0 a 1.0)',
    enabled BOOLEAN DEFAULT TRUE COMMENT 'Se o threshold está ativo',
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_category_name (category_name),
    INDEX idx_enabled (enabled)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir thresholds padrão (valores padrão da OpenAI são geralmente 0.5)
INSERT INTO moderation_thresholds (category_name, threshold_value, enabled, description) VALUES
('hate', 0.5000, TRUE, 'Ódio e discurso de ódio'),
('hate/threatening', 0.5000, TRUE, 'Ameaças baseadas em ódio'),
('harassment', 0.5000, TRUE, 'Assédio'),
('harassment/threatening', 0.5000, TRUE, 'Assédio ameaçador'),
('self-harm', 0.5000, TRUE, 'Autolesão'),
('self-harm/intent', 0.5000, TRUE, 'Intenção de autolesão'),
('self-harm/instructions', 0.5000, TRUE, 'Instruções de autolesão'),
('sexual', 0.5000, TRUE, 'Conteúdo sexual'),
('sexual/minors', 0.5000, TRUE, 'Conteúdo sexual envolvendo menores'),
('violence', 0.5000, TRUE, 'Violência'),
('violence/graphic', 0.5000, TRUE, 'Violência gráfica'),
('illicit', 0.5000, TRUE, 'Conteúdo ilícito'),
('illicit/violent', 0.5000, TRUE, 'Conteúdo ilícito/violento')
ON DUPLICATE KEY UPDATE threshold_value = VALUES(threshold_value);

