# Sistema de Histórico de Registros

Um sistema completo em PHP para gerenciar registros históricos de ações.

## Funcionalidades

- Listagem de registros com paginação
- Pesquisa por diversos campos (order_id, link, máquina, usuário)
- Visualização detalhada de registros
- Adição de novos registros
- Edição de registros existentes
- Contadores de status (Total, Erro, Completo) para pesquisas por order_id
- Botão "Completar Todos" para mudar status de todos os registros com mesmo order_id

## Requisitos

- PHP 7.0 ou superior
- MySQL 5.7 ou superior

## Estrutura do Banco de Dados

O sistema utiliza a seguinte tabela:

```sql
CREATE TABLE `history` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `maquina` VARCHAR(255) NOT NULL COLLATE 'utf8mb4_0900_ai_ci',
    `username` VARCHAR(255) NOT NULL COLLATE 'utf8mb4_0900_ai_ci',
    `profile` VARCHAR(255) NOT NULL COLLATE 'utf8mb4_0900_ai_ci',
    `data_acao` DATETIME NOT NULL,
    `orderid` INT NULL DEFAULT NULL,
    `link` TEXT NOT NULL COLLATE 'utf8mb4_0900_ai_ci',
    `comment` TEXT NOT NULL COLLATE 'utf8mb4_0900_ai_ci',
    `status` TEXT NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
    PRIMARY KEY (`id`) USING BTREE
)
COLLATE='utf8mb4_0900_ai_ci'
ENGINE=InnoDB;
```

## Instalação

1. Clone ou baixe os arquivos para o seu servidor web
2. Configure os dados de conexão com o banco de dados no arquivo `config.php`
3. Importe a estrutura da tabela para o seu banco de dados
4. Acesse o sistema pelo navegador

## Arquivos do Sistema

- `config.php`: Configurações de conexão com o banco de dados
- `index.php`: Página principal com listagem e pesquisa de registros
- `visualizar.php`: Página para visualizar detalhes de um registro
- `adicionar.php`: Página para adicionar um novo registro
- `editar.php`: Página para editar um registro existente
- `completar_todos.php`: Manipula a atualização em lote de registros para status "Completo"

## Interface

O sistema possui uma interface moderna e responsiva com:

- Design minimalista e compacto
- Tabela de dados otimizada com espaçamento reduzido
- Organização de colunas em ordem otimizada: orderID, Link, Comentário, Data, Usuário, Máquina, Status
- Status destacados com cores apropriadas (verde para Completo, vermelho para Erro)
- Contadores visuais para acompanhamento de status em pesquisas por order_id

## Segurança

Este sistema implementa medidas básicas de segurança:

- Uso de consultas preparadas para prevenção de injeção SQL
- Escape de saída para prevenção de XSS
- Validação de entradas nos formulários

## Melhorias Futuras

- Autenticação de usuários
- Exclusão de registros
- Exportação de dados
- Filtros avançados
- Logs de atividade 