<?php
// Versão otimizada que mostra resultados em tempo real
// Copie este código para substituir o script na página pendentes.php

echo "
<script>
document.addEventListener('DOMContentLoaded', () => {
    const pendingBadges = Array.from(document.querySelectorAll('.ai-badge.ai-pending'));
    if (pendingBadges.length === 0) return;
    
    // Processar em lotes pequenos para mostrar resultados em tempo real
    const batchSize = 5; // Processar 5 por vez
    let currentIndex = 0;
    
    const processBatch = () => {
        const batch = pendingBadges.slice(currentIndex, currentIndex + batchSize);
        if (batch.length === 0) return;
        
        // Mostrar que está processando
        batch.forEach(el => {
            el.textContent = 'Analisando...';
            el.classList.add('risk-neutral');
        });
        
        // Coletar comentários do lote
        const comments = batch.map(el => el.getAttribute('data-comment') || '');
        
        // Enviar lote para análise
        fetch('ia_analyze.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ comments })
        })
        .then(r => r.json())
        .then(data => {
            const results = (data && data.results) ? data.results : [];
            
            // Aplicar resultados imediatamente
            batch.forEach((el, i) => {
                const res = results[i] || { color: 'risk-neutral', label: 'Sem score', detail: '' };
                el.classList.remove('risk-neutral','risk-green','risk-yellow','risk-orange','risk-red','risk-blue');
                el.classList.add(res.color);
                el.textContent = res.label || 'OK';
                if (res.detail) el.title = res.detail;
                
                const dot = el.parentElement && el.parentElement.querySelector('.ai-dot');
                if (dot) {
                    dot.classList.remove('risk-neutral','risk-green','risk-yellow','risk-orange','risk-red','risk-blue');
                    dot.classList.add(res.color);
                }
            });
            
            // Processar próximo lote
            currentIndex += batchSize;
            if (currentIndex < pendingBadges.length) {
                setTimeout(processBatch, 100); // Pausa mínima entre lotes
            }
        })
        .catch(() => {
            // Em caso de erro, marcar como erro e continuar
            batch.forEach(el => {
                el.textContent = 'Erro';
                el.classList.add('risk-neutral');
            });
            
            currentIndex += batchSize;
            if (currentIndex < pendingBadges.length) {
                setTimeout(processBatch, 500);
            }
        });
    };
    
    // Iniciar processamento
    processBatch();
});
</script>
";
?>
