<?php
// Configurações do banco de dados
define('DB_HOST', '147.93.5.135');
define('DB_USER', 'su_aco');
define('DB_PASS', 'PR,~F!Z72*A4=JG(');
define('DB_NAME', 'su_co');

// Estabelecer conexão com o banco de dados
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Verificar conexão
if ($conn->connect_error) {
    die("Falha na conexão: " . $conn->connect_error);
}

// Definir caracteres UTF-8MB4 para suporte completo a emojis
$conn->set_charset("utf8mb4");

// Garantir que as tabelas tenham a coluna de aprovação
function ensure_approval_schema($conn, $tableName) {
    if (!($conn instanceof mysqli)) {
        return;
    }
    $tableNameSafe = preg_replace('/[^a-zA-Z0-9_]/', '', $tableName);
    $schema = DB_NAME;

    // Verificar coluna via INFORMATION_SCHEMA
    $checkColSql = "SELECT COUNT(*) AS cnt FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" . $conn->real_escape_string($schema) . "' AND TABLE_NAME = '" . $conn->real_escape_string($tableNameSafe) . "' AND COLUMN_NAME = 'approved'";
    $resCol = $conn->query($checkColSql);
    $colExists = 0;
    if ($resCol) {
        $row = $resCol->fetch_assoc();
        $colExists = intval($row['cnt'] ?? 0);
        $resCol->free();
    }
    if ($colExists === 0) {
        // Tentar adicionar coluna; ignorar erro de coluna duplicada (1060)
        try {
            $conn->query("ALTER TABLE `{$tableNameSafe}` ADD COLUMN `approved` TINYINT(1) NOT NULL DEFAULT 0");
        } catch (mysqli_sql_exception $e) {
            if ((int)$e->getCode() !== 1060) { // 1060 = Duplicate column name
                throw $e;
            }
        }
    }

    // Verificar índice
    $checkIdxSql = "SHOW INDEX FROM `{$tableNameSafe}` WHERE Key_name = 'idx_approved'";
    $resIdx = $conn->query($checkIdxSql);
    $idxExists = ($resIdx && $resIdx->num_rows > 0);
    if ($resIdx) { $resIdx->free(); }
    if (!$idxExists) {
        try {
            $conn->query("ALTER TABLE `{$tableNameSafe}` ADD INDEX `idx_approved` (`approved`)");
        } catch (mysqli_sql_exception $e) {
            if ((int)$e->getCode() !== 1061) { // 1061 = Duplicate key name
                throw $e;
            }
        }
    }
}

// Aplicar para as tabelas relevantes
ensure_approval_schema($conn, 'comments');
ensure_approval_schema($conn, 'commentsaleatorio');
ensure_approval_schema($conn, 'comments');

// Garantir que a tabela de blacklist existe
function ensure_blacklist_schema($conn) {
    if (!($conn instanceof mysqli)) {
        return;
    }
    
    $sql = "CREATE TABLE IF NOT EXISTS `comment_blacklist` (
        `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
        `phrase` TEXT NOT NULL,
        `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `idx_phrase` (`phrase`(255))
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    
    $conn->query($sql);
}

// Criar tabela de blacklist
ensure_blacklist_schema($conn);

// Garantir que a coluna description existe na tabela moderation_thresholds
function ensure_thresholds_description($conn) {
    if (!($conn instanceof mysqli)) {
        return;
    }
    
    // Verificar se a tabela existe
    $checkTable = $conn->query("SHOW TABLES LIKE 'moderation_thresholds'");
    if ($checkTable && $checkTable->num_rows > 0) {
        // Verificar se a coluna description existe
        $checkCol = $conn->query("SHOW COLUMNS FROM moderation_thresholds LIKE 'description'");
        if (!$checkCol || $checkCol->num_rows === 0) {
            // Adicionar coluna description
            try {
                $conn->query("ALTER TABLE moderation_thresholds ADD COLUMN `description` TEXT AFTER `enabled`");
            } catch (mysqli_sql_exception $e) {
                if ((int)$e->getCode() !== 1060) { // 1060 = Duplicate column name
                    // Ignorar outros erros silenciosamente
                }
            }
        }
    }
}

// Garantir coluna description nos thresholds
ensure_thresholds_description($conn);
?>