<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurar Thresholds - Sistema de Moderação</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="IA/assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="bi bi-shield-check"></i> Sistema de Moderação
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">
                            <i class="bi bi-clock-history"></i> Histórico
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="pendentes.php">
                            <i class="bi bi-clock"></i> Pendentes
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="aprovados.php">
                            <i class="bi bi-check-circle"></i> Aprovados
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="maquinas.php">
                            <i class="bi bi-desktop"></i> Máquinas
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="controlador.php">
                            <i class="bi bi-sliders"></i> Thresholds
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row mb-4">
            <div class="col-12">
                <h2><i class="bi bi-sliders"></i> Configurar Thresholds de Moderação</h2>
                <p class="text-muted">
                    Ajuste a sensibilidade da moderação por categoria. 
                    <strong>Valores menores = mais sensível</strong> (detecta mais), 
                    <strong>valores maiores = menos sensível</strong> (detecta menos).
                </p>
                <div class="alert alert-info">
                    <i class="bi bi-info-circle"></i> 
                    <strong>Como funciona:</strong> O threshold define a pontuação mínima (0.0 a 1.0) 
                    que a API precisa retornar para considerar uma categoria como detectada. 
                    Por exemplo, com threshold 0.3, qualquer pontuação ≥ 0.3 será considerada detectada.
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-list-check"></i> Thresholds por Categoria</h5>
                    </div>
                    <div class="card-body">
                        <div id="thresholdsList">
                            <div class="text-center py-5">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Carregando...</span>
                                </div>
                                <p class="mt-2">Carregando thresholds...</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <div class="card shadow">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="bi bi-lightbulb"></i> Dicas de Configuração</h5>
                    </div>
                    <div class="card-body">
                        <ul>
                            <li><strong>0.0 - 0.3:</strong> Muito sensível - detecta quase tudo (pode gerar falsos positivos)</li>
                            <li><strong>0.3 - 0.5:</strong> Sensível - detecta conteúdo claramente problemático</li>
                            <li><strong>0.5 - 0.7:</strong> Moderado - apenas conteúdo claramente problemático (padrão OpenAI)</li>
                            <li><strong>0.7 - 1.0:</strong> Menos sensível - apenas conteúdo extremamente problemático</li>
                        </ul>
                        <p class="mt-3 mb-0">
                            <strong>Recomendação:</strong> Comece com 0.5 (padrão) e ajuste baseado no feedback do sistema de treinamento.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Sobrescrever fetch para corrigir caminhos da API
        (function() {
            const originalFetch = window.fetch;
            window.fetch = function(url, options) {
                if (typeof url === 'string') {
                    // Corrigir caminhos que começam com 'api/' para 'IA/api/'
                    if (url.startsWith('api/')) {
                        url = 'IA/' + url;
                    }
                    // Corrigir caminhos que usam template string com API_BASE
                    // Ex: 'api/thresholds.php' -> 'IA/api/thresholds.php'
                    if (url.match(/^api\/[^\/]/)) {
                        url = 'IA/' + url;
                    }
                }
                return originalFetch.call(this, url, options);
            };
        })();
    </script>
    <script src="IA/assets/js/app.js"></script>
    <script src="IA/assets/js/thresholds.js"></script>
</body>
</html>
