<?php
/**
 * Teste de velocidade da API
 */
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Teste de Velocidade - API IA</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        button { padding: 10px 20px; margin: 10px; cursor: pointer; }
        .result { background: #f5f5f5; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .success { color: green; }
        .error { color: red; }
        .info { color: blue; }
        pre { background: #eee; padding: 10px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>Teste de Velocidade - API de Moderação IA</h1>
    
    <div>
        <h3>Testar diferentes quantidades:</h3>
        <button onclick="testAPI(1)">1 comentário</button>
        <button onclick="testAPI(5)">5 comentários</button>
        <button onclick="testAPI(10)">10 comentários</button>
        <button onclick="testAPI(20)">20 comentários</button>
        <button onclick="testAPI(50)">50 comentários</button>
    </div>
    
    <div id="results"></div>
    
    <script>
        async function testAPI(count) {
            const resultsDiv = document.getElementById('results');
            
            // Criar array de comentários de teste
            const comments = [];
            for (let i = 0; i < count; i++) {
                comments.push(`Comentário de teste número ${i + 1}`);
            }
            
            const resultBox = document.createElement('div');
            resultBox.className = 'result';
            resultBox.innerHTML = `<strong>Testando com ${count} comentário(s)...</strong><br>Iniciando...`;
            resultsDiv.insertBefore(resultBox, resultsDiv.firstChild);
            
            const startTime = Date.now();
            
            try {
                console.log(`Enviando ${count} comentários...`);
                
                const response = await fetch('ia_analyze_openai.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ comments })
                });
                
                const elapsed = ((Date.now() - startTime) / 1000).toFixed(2);
                
                const data = await response.json();
                
                if (response.ok) {
                    resultBox.innerHTML = `
                        <strong class="success">✓ Sucesso com ${count} comentário(s)</strong><br>
                        <span class="info">Tempo: ${elapsed}s</span><br>
                        <span class="info">Velocidade: ${(count / elapsed).toFixed(2)} comentários/segundo</span><br>
                        <details>
                            <summary>Ver resposta completa</summary>
                            <pre>${JSON.stringify(data, null, 2)}</pre>
                        </details>
                    `;
                } else {
                    resultBox.innerHTML = `
                        <strong class="error">✗ Erro com ${count} comentário(s)</strong><br>
                        <span class="info">Tempo: ${elapsed}s</span><br>
                        <span class="error">Erro: ${data.error || 'Erro desconhecido'}</span><br>
                        <pre>${JSON.stringify(data, null, 2)}</pre>
                    `;
                }
            } catch (error) {
                const elapsed = ((Date.now() - startTime) / 1000).toFixed(2);
                resultBox.innerHTML = `
                    <strong class="error">✗ Exceção com ${count} comentário(s)</strong><br>
                    <span class="info">Tempo: ${elapsed}s</span><br>
                    <span class="error">Erro: ${error.message}</span>
                `;
            }
        }
    </script>
</body>
</html>

