# 🔐 Sistema de Usuários - Instruções

## 📋 Configuração Inicial

### 1. Criar Tabela de Usuários
Execute o arquivo `create_users_table.php` no navegador:
```
http://seu-dominio.com/create_users_table.php
```

Isso criará:
- ✅ Tabela `users` no banco `su_ma`
- ✅ Usuário administrador padrão

### 2. Credenciais do Administrador
- **Email**: `admin@system.local`
- **Senha**: `admin123`
- **⚠️ ALTERE A SENHA IMEDIATAMENTE!**

## 🛡️ Acesso à Página de Cadastro

### Método 1: Link Oculto no Navbar
- Faça login como admin (`admin@system.local`)
- Aparecerá um botão "Admin" no navbar
- Clique para acessar a página de cadastro

### Método 2: URL Direta (Protegida)
```
http://seu-dominio.com/admin_register
```
- ⚠️ **BLOQUEADA** no .htaccess para usuários não autorizados
- Só funciona se estiver logado como admin

## 👥 Gerenciamento de Usuários

### Cadastrar Novo Usuário
1. Acesse a página de cadastro
2. Preencha os dados:
   - **Username**: Nome de usuário único
   - **Email**: Email válido e único
   - **Senha**: Mínimo 6 caracteres
   - **Confirmar Senha**: Deve coincidir
3. Clique em "Cadastrar Usuário"

### Visualizar Usuários
- Lista todos os usuários cadastrados
- Mostra ID, username, email, data de cadastro e status
- Ordenados por data de cadastro (mais recentes primeiro)

## 🔒 Segurança

### Proteções Implementadas
- ✅ **Senhas criptografadas** com `password_hash()`
- ✅ **Validação de email** e username únicos
- ✅ **Página protegida** no .htaccess
- ✅ **Verificação de admin** no código
- ✅ **Validação de dados** de entrada

### Arquivos Protegidos
- `.env` - Configurações sensíveis
- `config.php` - Configurações do sistema
- `create_users_table.php` - Script de criação
- `admin_register.php` - Página de cadastro

## 🚀 Como Usar

### Para Administradores
1. Faça login com `admin@system.local` / `admin123`
2. Clique no botão "Admin" no navbar
3. Cadastre novos usuários conforme necessário
4. **IMPORTANTE**: Altere a senha do admin imediatamente

### Para Usuários Normais
1. Acesse `http://seu-dominio.com/login`
2. Use as credenciais fornecidas pelo administrador
3. Acesso normal ao sistema

## 📝 Estrutura da Tabela

```sql
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    email VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    is_active TINYINT(1) DEFAULT 1
);
```

## ⚠️ Importante

1. **Execute `create_users_table.php` primeiro**
2. **Altere a senha do admin imediatamente**
3. **A página de cadastro só funciona para admin**
4. **Todos os logins agora vêm do banco de dados**
5. **Mantenha o arquivo `.env` seguro**

## 🔧 Solução de Problemas

### Erro de Conexão
- Verifique se o banco `su_ma` existe
- Confirme as credenciais no `.env`

### Usuário Não Encontrado
- Verifique se o usuário foi cadastrado
- Confirme se o email está correto

### Acesso Negado à Página de Cadastro
- Faça login como admin primeiro
- Verifique se o email é `admin@system.local`
