<?php
require_once 'config.php';
require_once 'functions.php';

// Filtro de gênero (mesmo de pendentes)
$filter_gender = isset($_GET['gender']) ? intval($_GET['gender']) : 0;

// Paginação
$limit = 50;
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $limit;

$approved_condition = "approved = 1";

$where_comments = "WHERE $approved_condition";
if ($filter_gender > 0) {
    if ($filter_gender == 4) {
        $where_comments = "WHERE gender IS NULL AND $approved_condition";
    } else {
        $where_comments = "WHERE gender = $filter_gender AND $approved_condition";
    }
}

$where_random = "WHERE $approved_condition";
if ($filter_gender > 0) {
    if ($filter_gender == 4) {
        $where_random = "WHERE 1=0";
    } else {
        $where_random = "WHERE gender = $filter_gender AND $approved_condition";
    }
}

$sql = "
    SELECT id, order_id, link, comment, gender, 'comments' AS source, 1 AS priority
    FROM comments
    $where_comments
    UNION ALL
    SELECT id, order_id, link, comment, gender, 'commentsaleatorio' AS source, 2 AS priority
    FROM commentsaleatorio
    $where_random
    ORDER BY priority ASC, id ASC
    LIMIT $limit OFFSET $offset
";
$result = $conn->query($sql);

$total_personalizado = $conn->query("SELECT COUNT(*) AS total FROM comments " . ($where_comments ? $where_comments : ""))->fetch_assoc()['total'];
$total_aleatorio = $conn->query("SELECT COUNT(*) AS total FROM commentsaleatorio " . ($where_random ? $where_random : ""))->fetch_assoc()['total'];
$total = $total_personalizado + $total_aleatorio;

function buildPaginationUrl($page_num) {
    $params = [];
    foreach ($_GET as $key => $value) {
        if ($key !== 'page') { $params[$key] = $value; }
    }
    $params['page'] = $page_num;
    return '?' . http_build_query($params);
}

// Totais por gênero (apenas aprovados)
$total_masculino = $conn->query("SELECT COUNT(*) AS total FROM comments WHERE gender = 1 AND $approved_condition")->fetch_assoc()['total'] +
                 $conn->query("SELECT COUNT(*) AS total FROM commentsaleatorio WHERE gender = 1 AND $approved_condition")->fetch_assoc()['total'];
$total_feminino = $conn->query("SELECT COUNT(*) AS total FROM comments WHERE gender = 2 AND $approved_condition")->fetch_assoc()['total'] +
                $conn->query("SELECT COUNT(*) AS total FROM commentsaleatorio WHERE gender = 2 AND $approved_condition")->fetch_assoc()['total'];
$total_unissex = $conn->query("SELECT COUNT(*) AS total FROM comments WHERE gender = 3 AND $approved_condition")->fetch_assoc()['total'] +
               $conn->query("SELECT COUNT(*) AS total FROM commentsaleatorio WHERE gender = 3 AND $approved_condition")->fetch_assoc()['total'];

// Total não definido (apenas aprovados)
$total_indefinido = $conn->query("SELECT COUNT(*) AS total FROM comments WHERE gender IS NULL AND $approved_condition")->fetch_assoc()['total'];

function buildGenderFilterUrl($gender_id) {
    $params = [];
    foreach ($_GET as $key => $value) {
        if ($key !== 'gender' && $key !== 'page') {
            $params[$key] = $value;
        }
    }
    if ($gender_id > 0) { $params['gender'] = $gender_id; }
    $query_string = http_build_query($params);
    return empty($query_string) ? '?' : '?' . $query_string;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Aprovados</title>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <main class="page-container">
        <?php
        // Métricas superiores (idênticas)
        $current_date = date('Y-m-d');
        $total_acoes_hoje = $conn->query("\n            SELECT COALESCE(SUM(actions_today), 0) AS total \n            FROM (\n                SELECT SUM(actions_today) AS actions_today FROM comentario01 WHERE DATE(last_action_date) = '$current_date'\n                UNION ALL\n                SELECT SUM(actions_today) AS actions_today FROM comentario02 WHERE DATE(last_action_date) = '$current_date'\n                UNION ALL\n                SELECT SUM(actions_today) AS actions_today FROM comentario03 WHERE DATE(last_action_date) = '$current_date'\n            ) AS totals\n        ")->fetch_assoc()['total'] ?? 0;
        $yesterday_date = date('Y-m-d', strtotime('-1 day'));
        $acoes_ontem = $conn->query("\n            SELECT COUNT(*) AS total \n            FROM history \n            WHERE DATE(data_acao) = '$yesterday_date'\n        ")->fetch_assoc()['total'] ?? 0;
        $total_pendentes_aprovar_header = $conn->query("\n            SELECT \n                (SELECT COUNT(*) FROM comments WHERE approved = 0) + \n                (SELECT COUNT(*) FROM commentsaleatorio WHERE approved = 0) AS total\n        ")->fetch_assoc()['total'] ?? 0;
        $total_aprovados_header = $conn->query("\n            SELECT \n                (SELECT COUNT(*) FROM comments WHERE approved = 1) + \n                (SELECT COUNT(*) FROM commentsaleatorio WHERE approved = 1) AS total\n        ")->fetch_assoc()['total'] ?? 0;
        $acoes_ultima_hora = $conn->query("\n            SELECT COUNT(*) AS total \n            FROM history \n            WHERE data_acao > DATE_SUB(NOW(), INTERVAL 60 MINUTE)\n        ")->fetch_assoc()['total'] ?? 0;
        $ultima_acao = $conn->query("\n            SELECT MAX(last_action_date) AS last_date FROM (\n                SELECT MAX(last_action_date) AS last_action_date FROM comentario01\n                UNION ALL\n                SELECT MAX(last_action_date) AS last_action_date FROM comentario02\n                UNION ALL\n                SELECT MAX(last_action_date) AS last_action_date FROM comentario03\n            ) AS dates\n        ")->fetch_assoc()['last_date'] ?? 'N/A';
        $ultima_acao_formatada = $ultima_acao != 'N/A' ? date('d/m/Y H:i:s', strtotime($ultima_acao)) : 'N/A';
        $previsao_zerar = 'N/A';
        if ($acoes_ultima_hora > 0 && $total_aprovados_header > 0) {
            $minutos_totais = ceil(($total_aprovados_header / $acoes_ultima_hora) * 60);
            if ($minutos_totais < 60) {
                $previsao_zerar = $minutos_totais . ' min';
            } else {
                $horas = floor($minutos_totais / 60);
                $minutos = $minutos_totais % 60;
                if ($horas < 24) {
                    $previsao_zerar = $horas . 'h ' . $minutos . 'min';
                } else {
                    $dias = floor($horas / 24);
                    $horas_restantes = $horas % 24;
                    $previsao_zerar = $dias . ' dias, ' . $horas_restantes . 'h ' . $minutos . 'min';
                }
            }
        }
        ?>
        <div class="metrics-summary">
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo number_format($total_acoes_hoje, 0, ',', '.'); ?></div>
                    <div class="metric-label">Ações Hoje <span style="font-size: 0.8em; opacity: 0.7;">(Ontem: <?php echo number_format($acoes_ontem, 0, ',', '.'); ?>)</span></div>
                </div>
            </div>
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-hourglass-half"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo number_format($total_pendentes_aprovar_header, 0, ',', '.'); ?></div>
                    <div class="metric-label">Pendentes p/ aprovar</div>
                </div>
            </div>
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo number_format($total_aprovados_header, 0, ',', '.'); ?></div>
                    <div class="metric-label">Aprovados (prontos)</div>
                </div>
            </div>
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-tachometer-alt"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo number_format($acoes_ultima_hora, 0, ',', '.'); ?></div>
                    <div class="metric-label">Ações na última hora</div>
                </div>
            </div>
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-hourglass-end"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo $previsao_zerar; ?></div>
                    <div class="metric-label">Previsão para zerar</div>
                </div>
            </div>
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo $ultima_acao_formatada; ?></div>
                    <div class="metric-label">Última Ação</div>
                </div>
            </div>
        </div>
        <style>
            .totals {
                display: flex;
                gap: 1rem;
                margin-bottom: 1rem;
            }
            .totals span {
                padding: 0.5rem 1rem;
                background-color: var(--color-surface-variant);
                border-radius: var(--border-radius-md);
                font-size: var(--font-size-sm);
                color: var(--color-text-secondary);
            }
            .total-link { text-decoration: none; transition: all 0.2s ease; }
            .total-link span {
                padding: 0.5rem 1rem;
                background-color: var(--color-surface-variant);
                border-radius: var(--border-radius-md);
                font-size: var(--font-size-sm);
                color: var(--color-text-secondary);
                transition: all 0.2s ease;
            }
            .total-link.active span { background-color: var(--color-primary-light); color: var(--color-primary); font-weight: 600; }
            .total-link:hover span { background-color: var(--color-primary-light); color: var(--color-primary); }
            @media (min-width: 1200px) {
                .table td.col-link, .table td.col-comment { padding-right: 10px; }
                .table .truncate { width: 100%; display: block; }
            }
            .col-gender { width: 100px; text-align: center; }
            td.col-gender { font-size: 0.9em; }
            .action-icon.delete-all { background-color: #dc3545; margin-left: 5px; }
            .action-icon.delete-all:hover { background-color: #bd2130; }
        </style>

        <section class="card">
            <div class="card-header">
                <h2 class="card-title">Comentários Aprovados</h2>
                <?php if ($filter_gender > 0): ?>
                    <a href="aprovados" class="btn btn-secondary btn-sm">Limpar filtros</a>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <div class="totals">
                    <a href="<?php echo buildGenderFilterUrl(0); ?>" class="total-link <?php echo $filter_gender == 0 ? 'active' : ''; ?>">
                        <span>Total Geral: <?php echo $total; ?></span>
                    </a>
                    <a href="<?php echo buildGenderFilterUrl(1); ?>" class="total-link <?php echo $filter_gender == 1 ? 'active' : ''; ?>">
                        <span>Total Masculino: <?php echo $total_masculino; ?></span>
                    </a>
                    <a href="<?php echo buildGenderFilterUrl(2); ?>" class="total-link <?php echo $filter_gender == 2 ? 'active' : ''; ?>">
                        <span>Total Feminino: <?php echo $total_feminino; ?></span>
                    </a>
                    <a href="<?php echo buildGenderFilterUrl(3); ?>" class="total-link <?php echo $filter_gender == 3 ? 'active' : ''; ?>">
                        <span>Total Unissex: <?php echo $total_unissex; ?></span>
                    </a>
                    <?php if ($total_indefinido > 0): ?>
                    <a href="<?php echo buildGenderFilterUrl(4); ?>" class="total-link <?php echo $filter_gender == 4 ? 'active' : ''; ?>">
                        <span>Não definido: <?php echo $total_indefinido; ?></span>
                    </a>
                    <?php endif; ?>
                </div>
                <div class="bulk-actions" style="margin-bottom:10px; display:flex; gap:8px; align-items:center;">
                    <button type="button" id="bulkDelete" class="btn btn-secondary btn-sm">
                        <i class="fas fa-trash-alt"></i>Excluir Selecionados
                    </button>
                </div>
                <?php if ($result && $result->num_rows > 0): ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th style="width:50px;">
                                        <input type="checkbox" id="selectAll">
                                    </th>
                                    <th class="col-order-id">Order ID</th>
                                    <th class="col-link">Link</th>
                                    <th class="col-comment">Comentário</th>
                                    <th class="col-gender">Gênero</th>
                                    <th class="col-actions">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($row = $result->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <input type="checkbox" class="row-check" value="<?php echo $row['id']; ?>" data-source="<?php echo exibir_texto($row['source']); ?>">
                                        </td>
                                        <td><?php echo exibir_texto($row['order_id']); ?></td>
                                        <td class="col-link" title="<?php echo exibir_texto($row['link']); ?>">
                                            <span class="truncate"><?php echo exibir_texto($row['link']); ?></span>
                                        </td>
                                        <td class="col-comment" title="<?php echo exibir_texto($row['comment']); ?>">
                                            <span class="truncate"><?php echo exibir_texto($row['comment']); ?></span>
                                        </td>
                                        <td class="col-gender"><?php echo $row['gender'] === null ? 'Não definido' : ($row['gender'] == 1 ? 'Masculino' : ($row['gender'] == 2 ? 'Feminino' : 'Unissex')); ?></td>
                                        <td class="col-actions">
                                            <form method="POST" style="margin: 0; display: inline-block;">
                                                <input type="hidden" name="delete_id" value="<?php echo $row['id']; ?>">
                                                <input type="hidden" name="source" value="<?php echo exibir_texto($row['source']); ?>">
                                                <button type="submit" class="action-icon delete" title="Excluir">
                                                    <i class="fas fa-trash-alt"></i>
                                                </button>
                                            </form>
                                            <form method="POST" style="margin: 0; display: inline-block;">
                                                <input type="hidden" name="delete_link" value="<?php echo exibir_texto($row['link']); ?>">
                                                <input type="hidden" name="source" value="<?php echo exibir_texto($row['source']); ?>">
                                                <button type="submit" class="action-icon delete-all" title="Excluir todos com mesmo link" onclick="return confirm('Tem certeza que deseja excluir todos os comentários com este mesmo link?');">
                                                    <i class="fas fa-dumpster"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <script>
                        (function(){
                            const selectAll = document.getElementById('selectAll');
                            const rowChecks = () => Array.from(document.querySelectorAll('.row-check'));
                            const setAll = (checked) => rowChecks().forEach(cb => { cb.checked = checked; });
                            const syncHeader = () => {
                                const cbs = rowChecks();
                                const all = cbs.length > 0 && cbs.every(cb => cb.checked);
                                const any = cbs.some(cb => cb.checked);
                                if (selectAll) {
                                    selectAll.checked = all;
                                    selectAll.indeterminate = !all && any;
                                }
                            };
                            if (selectAll) selectAll.addEventListener('change', e => { setAll(e.target.checked); syncHeader(); });
                            document.addEventListener('change', e => { if (e.target.classList && e.target.classList.contains('row-check')) syncHeader(); });

                            function submitBulkDelete(){
                                const selected = rowChecks().filter(cb => cb.checked);
                                if (selected.length === 0) { alert('Selecione pelo menos um item.'); return; }
                                const form = document.createElement('form');
                                form.method = 'POST';
                                form.action = '';
                                form.style.display = 'none';
                                const inpAction = document.createElement('input');
                                inpAction.type = 'hidden'; inpAction.name = 'action'; inpAction.value = 'bulk_delete';
                                form.appendChild(inpAction);
                                selected.forEach(cb => {
                                    const idInput = document.createElement('input');
                                    idInput.type = 'hidden'; idInput.name = 'ids[]'; idInput.value = cb.value;
                                    form.appendChild(idInput);
                                    const srcInput = document.createElement('input');
                                    srcInput.type = 'hidden'; srcInput.name = `sources[${cb.value}]`; srcInput.value = cb.getAttribute('data-source');
                                    form.appendChild(srcInput);
                                });
                                document.body.appendChild(form);
                                form.submit();
                            }
                            const bulkDelete = document.getElementById('bulkDelete');
                            if (bulkDelete) bulkDelete.addEventListener('click', submitBulkDelete);
                        })();
                    </script>
                    <div class="pagination">
                        <?php for ($i = 1; $i <= ceil($total / $limit); $i++): ?>
                            <a href="<?php echo buildPaginationUrl($i); ?>" class="<?php echo $page == $i ? 'active' : ''; ?>">
                                <?php echo $i; ?>
                            </a>
                        <?php endfor; ?>
                    </div>
                <?php else: ?>
                    <div class="empty-state">
                        <i class="fas fa-info-circle"></i>
                        <p>Não há comentários aprovados</p>
                    </div>
                <?php endif; ?>
            </div>
        </section>
    </main>

    <footer class="footer">
        <div class="container">
            <p class="text-center text-muted">© <?php echo date('Y'); ?> Sistema de Comentários</p>
        </div>
    </footer>

    <?php $conn->close(); ?>
    <script>
    // Copiar link ao clicar no campo de link, sem popup
    document.addEventListener('DOMContentLoaded', () => {
        const linkCells = document.querySelectorAll('td.col-link');
        linkCells.forEach(cell => {
            cell.addEventListener('click', () => {
                const link = cell.getAttribute('title') || cell.textContent.trim();
                if (!link) return;
                navigator.clipboard.writeText(link).catch(() => {});
            });
        });
    });
    </script>
</body>
</html>


