<?php
require_once 'config.php';
requireLogin();

// Função auxiliar para exibir texto com emojis corretamente
function exibir_texto($texto) {
    return htmlspecialchars($texto, ENT_QUOTES, 'UTF-8');
}

// Configurar charset UTF-8 para suportar emojis
if (isset($conn) && $conn instanceof mysqli) {
    $conn->set_charset("utf8mb4");
}

// Verificar se é uma requisição POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: comentarios.php');
    exit;
}

// Obter order_id
$order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : 0;

if ($order_id <= 0) {
    header('Location: comentarios.php?error=1');
    exit;
}

// Atualizar todos os registros com o order_id para status "Completo"
$update_sql = "UPDATE history SET status = 'Completo' WHERE orderid = ?";
$stmt = $conn->prepare($update_sql);

if ($stmt) {
    $stmt->bind_param('i', $order_id);
    $stmt->execute();
    $stmt->close();
    
    // Redirecionar com mensagem de sucesso
    header('Location: comentarios.php?success=1');
} else {
    // Redirecionar com mensagem de erro
    header('Location: comentarios.php?error=1');
}

exit;
?>
