<?php
// Script para criar tabela de usuários
require_once 'config.php';

// Verificar se a conexão com o banco principal existe
if (!$mysqli) {
    die("Erro: Não foi possível conectar ao banco de dados principal.");
}

// SQL para criar a tabela users
$sql = "CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    is_active TINYINT(1) DEFAULT 1,
    INDEX idx_username (username),
    INDEX idx_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($mysqli->query($sql) === TRUE) {
    echo "✅ Tabela 'users' criada com sucesso!\n";
    
    // Verificar se já existe algum usuário
    $check = $mysqli->query("SELECT COUNT(*) as count FROM users");
    $count = $check->fetch_assoc()['count'];
    
    if ($count == 0) {
        // Criar usuário administrador padrão
        $admin_username = $_ENV['ADMIN_USERNAME'];
        $admin_password = password_hash($_ENV['ADMIN_DEFAULT_PASSWORD'], PASSWORD_DEFAULT);
        
        $insert_sql = "INSERT INTO users (username, password) VALUES (?, ?)";
        $stmt = $mysqli->prepare($insert_sql);
        $stmt->bind_param("ss", $admin_username, $admin_password);
        
        if ($stmt->execute()) {
            echo "✅ Usuário administrador criado:\n";
            echo "   Username: admin\n";
            echo "   Senha: admin123\n";
            echo "   ⚠️  ALTERE A SENHA IMEDIATAMENTE!\n";
        } else {
            echo "❌ Erro ao criar usuário administrador: " . $stmt->error . "\n";
        }
        $stmt->close();
    } else {
        echo "ℹ️  Tabela já possui $count usuário(s) cadastrado(s).\n";
    }
} else {
    echo "❌ Erro ao criar tabela: " . $mysqli->error . "\n";
}

$mysqli->close();
?>
