<?php
// Debug da página de admin
require_once 'config.php';

echo "<h1>Debug - Página de Admin</h1>";

// Verificar se está logado
echo "<h2>Status de Login:</h2>";
if (isLoggedIn()) {
    echo "✅ Usuário logado<br>";
    echo "Email: " . ($_SESSION['user_email'] ?? 'Não definido') . "<br>";
    echo "ID: " . ($_SESSION['user_id'] ?? 'Não definido') . "<br>";
} else {
    echo "❌ Usuário NÃO logado<br>";
    echo "<a href='login'>Fazer login</a><br>";
    exit;
}

// Verificar conexão com banco
echo "<h2>Conexão com Banco:</h2>";
if ($mysqli) {
    echo "✅ Conexão OK<br>";
    
    // Verificar se tabela users existe
    $result = $mysqli->query("SHOW TABLES LIKE 'users'");
    if ($result && $result->num_rows > 0) {
        echo "✅ Tabela 'users' existe<br>";
        
        // Verificar usuário admin
        $admin_check = $mysqli->prepare("SELECT id, username, email FROM users WHERE email = ?");
        $admin_check->bind_param("s", $_SESSION['user_email']);
        $admin_check->execute();
        $admin_result = $admin_check->get_result();
        
        if ($admin_result->num_rows > 0) {
            $admin_user = $admin_result->fetch_assoc();
            echo "✅ Usuário encontrado no banco:<br>";
            echo "ID: " . $admin_user['id'] . "<br>";
            echo "Username: " . $admin_user['username'] . "<br>";
            echo "Email: " . $admin_user['email'] . "<br>";
            
            if ($admin_user['username'] === 'admin') {
                echo "✅ É ADMIN!<br>";
                echo "<a href='admin_register'>Acessar página de cadastro</a><br>";
            } else {
                echo "❌ NÃO é admin (username: " . $admin_user['username'] . ")<br>";
            }
        } else {
            echo "❌ Usuário não encontrado no banco<br>";
        }
        $admin_check->close();
    } else {
        echo "❌ Tabela 'users' NÃO existe<br>";
        echo "<a href='create_users_table.php'>Criar tabela</a><br>";
    }
} else {
    echo "❌ Erro de conexão<br>";
}

echo "<br><a href='index'>Voltar ao sistema</a>";
?>
