<?php
require_once 'config.php';
require_once 'functions.php';

// Data atual dinâmica
$current_date = date('Y-m-d');

// Dashboard Metrics para cada maquina
// Comentario 01
$total_valido_01 = $conn->query("SELECT COUNT(*) AS total FROM comentario01 WHERE status = 0")->fetch_assoc()['total'] ?? 0;
$total_erro_01 = $conn->query("SELECT COUNT(*) AS total FROM comentario01 WHERE status = 1")->fetch_assoc()['total'] ?? 0;
$total_descanso_01 = $conn->query("SELECT COUNT(*) AS total FROM comentario01 WHERE status = 3")->fetch_assoc()['total'] ?? 0;
$last_action_date_01 = $conn->query("SELECT MAX(last_action_date) AS last_date FROM comentario01")->fetch_assoc()['last_date'] ?? 'N/A';
$total_actions_today_01 = $conn->query("
    SELECT SUM(actions_today) AS total 
    FROM comentario01 
    WHERE actions_today > 0 
    AND DATE(last_action_date) = '$current_date'
")->fetch_assoc()['total'] ?? 0;

// Comentario 02
$total_valido_02 = $conn->query("SELECT COUNT(*) AS total FROM comentario02 WHERE status = 0")->fetch_assoc()['total'] ?? 0;
$total_erro_02 = $conn->query("SELECT COUNT(*) AS total FROM comentario02 WHERE status = 1")->fetch_assoc()['total'] ?? 0;
$total_descanso_02 = $conn->query("SELECT COUNT(*) AS total FROM comentario02 WHERE status = 3")->fetch_assoc()['total'] ?? 0;
$last_action_date_02 = $conn->query("SELECT MAX(last_action_date) AS last_date FROM comentario02")->fetch_assoc()['last_date'] ?? 'N/A';
$total_actions_today_02 = $conn->query("
    SELECT SUM(actions_today) AS total 
    FROM comentario02 
    WHERE actions_today > 0 
    AND DATE(last_action_date) = '$current_date'
")->fetch_assoc()['total'] ?? 0;

// Comentario 03
$total_valido_03 = $conn->query("SELECT COUNT(*) AS total FROM comentario03 WHERE status = 0")->fetch_assoc()['total'] ?? 0;
$total_erro_03 = $conn->query("SELECT COUNT(*) AS total FROM comentario03 WHERE status = 1")->fetch_assoc()['total'] ?? 0;
$total_descanso_03 = $conn->query("SELECT COUNT(*) AS total FROM comentario03 WHERE status = 3")->fetch_assoc()['total'] ?? 0;
$last_action_date_03 = $conn->query("SELECT MAX(last_action_date) AS last_date FROM comentario03")->fetch_assoc()['last_date'] ?? 'N/A';
$total_actions_today_03 = $conn->query("
    SELECT SUM(actions_today) AS total 
    FROM comentario03 
    WHERE actions_today > 0 
    AND DATE(last_action_date) = '$current_date'
")->fetch_assoc()['total'] ?? 0;

// Comentario Masc
$total_valido_masc = $conn->query("SELECT COUNT(*) AS total FROM comentariomasc WHERE status = 0")->fetch_assoc()['total'] ?? 0;
$total_erro_masc = $conn->query("SELECT COUNT(*) AS total FROM comentariomasc WHERE status = 1")->fetch_assoc()['total'] ?? 0;
$total_descanso_masc = $conn->query("SELECT COUNT(*) AS total FROM comentariomasc WHERE status = 3")->fetch_assoc()['total'] ?? 0;
$last_action_date_masc = $conn->query("SELECT MAX(last_action_date) AS last_date FROM comentariomasc")->fetch_assoc()['last_date'] ?? 'N/A';
$total_actions_today_masc = $conn->query("
    SELECT SUM(actions_today) AS total 
    FROM comentariomasc 
    WHERE actions_today > 0 
    AND DATE(last_action_date) = '$current_date'
")->fetch_assoc()['total'] ?? 0;

// Total geral de todas as máquinas
$total_maquinas_valido = $total_valido_01 + $total_valido_02 + $total_valido_03 + $total_valido_masc;
$total_maquinas_erro = $total_erro_01 + $total_erro_02 + $total_erro_03 + $total_erro_masc;
$total_maquinas_descanso = $total_descanso_01 + $total_descanso_02 + $total_descanso_03 + $total_descanso_masc;
$total_acoes_hoje = $total_actions_today_01 + $total_actions_today_02 + $total_actions_today_03 + $total_actions_today_masc;

// Ações de ontem
$yesterday_date = date('Y-m-d', strtotime('-1 day'));
$acoes_ontem = $conn->query("
    SELECT COUNT(*) AS total 
    FROM history 
    WHERE DATE(data_acao) = '$yesterday_date'
")->fetch_assoc()['total'] ?? 0;

// Processar reset de status 3 se solicitado
if (isset($_POST['reset_status_3'])) {
    $maquina = $_POST['maquina'];
    
    if ($maquina == 1) {
        $conn->query("UPDATE comentario01 SET status = 0 WHERE status = 3");
    } elseif ($maquina == 2) {
        $conn->query("UPDATE comentario02 SET status = 0 WHERE status = 3");
    } elseif ($maquina == 3) {
        $conn->query("UPDATE comentario03 SET status = 0 WHERE status = 3");
    } elseif ($maquina == 'masc') {
        $conn->query("UPDATE comentariomasc SET status = 0 WHERE status = 3");
    }
    
    // Redirecionar para evitar reenvio do formulário
    header("Location: maquinas.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Comentários</title>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="styles.css">
    <style>
        .dashboard-container {
            padding: 1.5rem;
        }
        
        .dashboard-title {
            font-size: var(--font-size-xl);
            margin-bottom: 1.5rem;
            color: var(--color-text-primary);
            text-align: center;
        }
        
        .dashboard-section {
            background-color: var(--color-surface);
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .dashboard-section h3 {
            font-size: var(--font-size-lg);
            margin-bottom: 1rem;
            color: var(--color-primary);
            border-bottom: 1px solid var(--color-border);
            padding-bottom: 0.5rem;
            display: flex;
            align-items: center;
        }
        
        .dashboard-section h3 i {
            margin-right: 0.75rem;
        }
        
        .dashboard-metrics-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .dashboard-metrics-table th,
        .dashboard-metrics-table td {
            padding: 0.75rem 1rem;
            border-bottom: 1px solid var(--color-border-light);
        }
        
        .dashboard-metrics-table th {
            text-align: left;
            font-weight: 600;
            color: var(--color-text-secondary);
            background-color: var(--color-surface-variant);
        }
        
        .dashboard-metrics-table tr:last-child td {
            border-bottom: none;
        }
        
        .dashboard-totals {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .total-card {
            background-color: var(--color-surface);
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            padding: 1.5rem;
            text-align: center;
        }
        
        .total-card i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        
        .total-card .value {
            font-size: var(--font-size-2xl);
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .total-card .label {
            color: var(--color-text-secondary);
            font-size: var(--font-size-sm);
        }
        
        .total-card.valido {
            border-top: 4px solid var(--color-success);
        }
        
        .total-card.valido i {
            color: var(--color-success);
        }
        
        .total-card.erro {
            border-top: 4px solid var(--color-danger);
        }
        
        .total-card.erro i {
            color: var(--color-danger);
        }
        
        .total-card.descanso {
            border-top: 4px solid var(--color-warning);
        }
        
        .total-card.descanso i {
            color: var(--color-warning);
        }
        
        .total-card.acoes {
            border-top: 4px solid var(--color-primary);
        }
        
        .total-card.acoes i {
            color: var(--color-primary);
        }
        
        .btn-reset {
            background-color: var(--color-primary);
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: var(--border-radius-sm);
            cursor: pointer;
            font-weight: 600;
            transition: background-color 0.3s;
        }
        
        .btn-reset:hover {
            background-color: var(--color-primary-dark);
        }
        
        .main-menu {
            display: flex;
            background-color: var(--color-surface);
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            overflow: hidden;
            margin-bottom: 2rem;
        }
        
        .main-menu a {
            padding: 1rem 1.5rem;
            color: var(--color-text-secondary);
            text-decoration: none;
            font-weight: 600;
            display: flex;
            align-items: center;
            transition: all var(--transition-base);
            border-bottom: 3px solid transparent;
        }
        
        .main-menu a.active {
            color: var(--color-primary);
            background-color: var(--color-primary-light);
            border-bottom-color: var(--color-primary);
        }
        
        .main-menu a:hover:not(.active) {
            background-color: var(--color-surface-variant);
            color: var(--color-text-primary);
        }
        
        .main-menu i {
            margin-right: 0.5rem;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <main class="page-container">
        <?php
        // Consultar métricas adicionais
        
        // Ações na última hora (60 minutos exatos)
        $acoes_ultima_hora = $conn->query("
            SELECT COUNT(*) AS total 
            FROM history 
            WHERE data_acao > DATE_SUB(NOW(), INTERVAL 60 MINUTE)
        ")->fetch_assoc()['total'] ?? 0;
        
        // Pendentes para aprovar e aprovados
        $total_pendentes_aprovar = $conn->query("
            SELECT 
                (SELECT COUNT(*) FROM comments WHERE approved = 0) + 
                (SELECT COUNT(*) FROM commentsaleatorio WHERE approved = 0) AS total
        ")->fetch_assoc()['total'] ?? 0;
        $total_aprovados = $conn->query("
            SELECT 
                (SELECT COUNT(*) FROM comments WHERE approved = 1) + 
                (SELECT COUNT(*) FROM commentsaleatorio WHERE approved = 1) AS total
        ")->fetch_assoc()['total'] ?? 0;
        
        // Data da última ação
        $ultima_acao = $conn->query("
            SELECT MAX(last_action_date) AS last_date FROM (
                SELECT MAX(last_action_date) AS last_action_date FROM comentario01
                UNION ALL
                SELECT MAX(last_action_date) AS last_action_date FROM comentario02
                UNION ALL
                SELECT MAX(last_action_date) AS last_action_date FROM comentario03
                UNION ALL
                SELECT MAX(last_action_date) AS last_action_date FROM comentariomasc
            ) AS dates
        ")->fetch_assoc()['last_date'] ?? 'N/A';
        
        // Formatar data da última ação
        $ultima_acao_formatada = $ultima_acao != 'N/A' ? date('d/m/Y H:i:s', strtotime($ultima_acao)) : 'N/A';
        
        // Calcular previsão para zerar
        $previsao_zerar = 'N/A';
        if ($acoes_ultima_hora > 0 && $total_aprovados > 0) {
            // Calcular minutos totais para zerar
            $minutos_totais = ceil(($total_aprovados / $acoes_ultima_hora) * 60);
            
            if ($minutos_totais < 60) {
                // Se for menos de 1 hora, mostrar em minutos
                $previsao_zerar = $minutos_totais . ' min';
            } else {
                // Calcular horas e minutos
                $horas = floor($minutos_totais / 60);
                $minutos = $minutos_totais % 60;
                
                if ($horas < 24) {
                    // Se for menos de 24 horas, mostrar em horas e minutos
                    $previsao_zerar = $horas . 'h ' . $minutos . 'min';
                } else {
                    // Senão, mostrar em dias, horas e minutos
                    $dias = floor($horas / 24);
                    $horas_restantes = $horas % 24;
                    $previsao_zerar = $dias . ' dias, ' . $horas_restantes . 'h ' . $minutos . 'min';
                }
            }
        }
        ?>
        
        <div class="metrics-summary">
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo number_format($total_acoes_hoje, 0, ',', '.'); ?></div>
                    <div class="metric-label">Ações Hoje <span style="font-size: 0.8em; opacity: 0.7;">(Ontem: <?php echo number_format($acoes_ontem, 0, ',', '.'); ?>)</span></div>
                </div>
            </div>
            
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-hourglass-half"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo number_format($total_pendentes_aprovar, 0, ',', '.'); ?></div>
                    <div class="metric-label">Pendentes p/ aprovar</div>
                </div>
            </div>
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo number_format($total_aprovados, 0, ',', '.'); ?></div>
                    <div class="metric-label">Aprovados (prontos)</div>
                </div>
            </div>
            
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-tachometer-alt"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo number_format($acoes_ultima_hora, 0, ',', '.'); ?></div>
                    <div class="metric-label">Ações na última hora</div>
                </div>
            </div>
            
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-hourglass-end"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo $previsao_zerar; ?></div>
                    <div class="metric-label">Previsão para zerar</div>
                </div>
            </div>
            
            <div class="metric-item">
                <div class="metric-icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <div class="metric-info">
                    <div class="metric-value"><?php echo $ultima_acao_formatada; ?></div>
                    <div class="metric-label">Última Ação</div>
                </div>
            </div>
        </div>
        

        <div class="dashboard-totals">
            <div class="total-card valido">
                <i class="fas fa-check-circle"></i>
                <div class="value"><?php echo $total_maquinas_valido; ?></div>
                <div class="label">Total Válido</div>
            </div>
            <div class="total-card erro">
                <i class="fas fa-exclamation-circle"></i>
                <div class="value"><?php echo $total_maquinas_erro; ?></div>
                <div class="label">Total Erro</div>
            </div>
            <div class="total-card descanso">
                <i class="fas fa-bed"></i>
                <div class="value"><?php echo $total_maquinas_descanso; ?></div>
                <div class="label">Total Descanso</div>
            </div>
            <div class="total-card acoes">
                <i class="fas fa-chart-line"></i>
                <div class="value"><?php echo $total_acoes_hoje; ?></div>
                <div class="label">Ações Hoje (<?php echo date('d/m/Y'); ?>)</div>
            </div>
        </div>

        <div class="dashboard-container">
            <div class="dashboard-section">
                <h3><i class="fas fa-laptop"></i>Máquina 01</h3>
                <table class="dashboard-metrics-table">
                    <tr>
                        <th>Métrica</th>
                        <th>Valor</th>
                    </tr>
                    <tr>
                        <td>Total Válido</td>
                        <td><?php echo $total_valido_01; ?></td>
                    </tr>
                    <tr>
                        <td>Total Erro</td>
                        <td><?php echo $total_erro_01; ?></td>
                    </tr>
                    <tr>
                        <td>Total Descanso</td>
                        <td>
                            <?php echo $total_descanso_01; ?>
                            <form method="post" style="display: inline; margin-left: 10px;">
                                <input type="hidden" name="maquina" value="1">
                                <button type="submit" name="reset_status_3" class="btn-reset">Resetar</button>
                            </form>
                        </td>
                    </tr>
                    <tr>
                        <td>Data da Última Ação</td>
                        <td><?php echo $last_action_date_01; ?></td>
                    </tr>
                    <tr>
                        <td>Total de Ações Hoje</td>
                        <td><?php echo $total_actions_today_01; ?></td>
                    </tr>
                </table>
            </div>

            <div class="dashboard-section">
                <h3><i class="fas fa-laptop"></i>Máquina 02</h3>
                <table class="dashboard-metrics-table">
                    <tr>
                        <th>Métrica</th>
                        <th>Valor</th>
                    </tr>
                    <tr>
                        <td>Total Válido</td>
                        <td><?php echo $total_valido_02; ?></td>
                    </tr>
                    <tr>
                        <td>Total Erro</td>
                        <td><?php echo $total_erro_02; ?></td>
                    </tr>
                    <tr>
                        <td>Total Descanso</td>
                        <td>
                            <?php echo $total_descanso_02; ?>
                            <form method="post" style="display: inline; margin-left: 10px;">
                                <input type="hidden" name="maquina" value="2">
                                <button type="submit" name="reset_status_3" class="btn-reset">Resetar</button>
                            </form>
                        </td>
                    </tr>
                    <tr>
                        <td>Data da Última Ação</td>
                        <td><?php echo $last_action_date_02; ?></td>
                    </tr>
                    <tr>
                        <td>Total de Ações Hoje</td>
                        <td><?php echo $total_actions_today_02; ?></td>
                    </tr>
                </table>
            </div>

            <div class="dashboard-section">
                <h3><i class="fas fa-laptop"></i>Máquina 03</h3>
                <table class="dashboard-metrics-table">
                    <tr>
                        <th>Métrica</th>
                        <th>Valor</th>
                    </tr>
                    <tr>
                        <td>Total Válido</td>
                        <td><?php echo $total_valido_03; ?></td>
                    </tr>
                    <tr>
                        <td>Total Erro</td>
                        <td><?php echo $total_erro_03; ?></td>
                    </tr>
                    <tr>
                        <td>Total Descanso</td>
                        <td>
                            <?php echo $total_descanso_03; ?>
                            <form method="post" style="display: inline; margin-left: 10px;">
                                <input type="hidden" name="maquina" value="3">
                                <button type="submit" name="reset_status_3" class="btn-reset">Resetar</button>
                            </form>
                        </td>
                    </tr>
                    <tr>
                        <td>Data da Última Ação</td>
                        <td><?php echo $last_action_date_03; ?></td>
                    </tr>
                    <tr>
                        <td>Total de Ações Hoje</td>
                        <td><?php echo $total_actions_today_03; ?></td>
                    </tr>
                </table>
            </div>

            <div class="dashboard-section">
                <h3><i class="fas fa-laptop"></i>Máquina Masc</h3>
                <table class="dashboard-metrics-table">
                    <tr>
                        <th>Métrica</th>
                        <th>Valor</th>
                    </tr>
                    <tr>
                        <td>Total Válido</td>
                        <td><?php echo $total_valido_masc; ?></td>
                    </tr>
                    <tr>
                        <td>Total Erro</td>
                        <td><?php echo $total_erro_masc; ?></td>
                    </tr>
                    <tr>
                        <td>Total Descanso</td>
                        <td>
                            <?php echo $total_descanso_masc; ?>
                            <form method="post" style="display: inline; margin-left: 10px;">
                                <input type="hidden" name="maquina" value="masc">
                                <button type="submit" name="reset_status_3" class="btn-reset">Resetar</button>
                            </form>
                        </td>
                    </tr>
                    <tr>
                        <td>Data da Última Ação</td>
                        <td><?php echo $last_action_date_masc; ?></td>
                    </tr>
                    <tr>
                        <td>Total de Ações Hoje</td>
                        <td><?php echo $total_actions_today_masc; ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <p class="text-center text-muted">© <?php echo date('Y'); ?> Sistema de Comentários</p>
        </div>
    </footer>

    <?php $conn->close(); ?>
</body>
</html> 