<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Navbar Demo - <?= APP_NAME ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/navbar.css">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
            background: var(--color-background);
        }
        
        .demo-content {
            padding: 2rem;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .demo-section {
            background: var(--color-surface);
            border-radius: var(--border-radius-lg);
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: var(--shadow-md);
        }
        
        .demo-title {
            color: var(--color-primary);
            margin-bottom: 1rem;
            font-size: 1.5rem;
            font-weight: 600;
        }
        
        .demo-text {
            color: var(--color-text-secondary);
            line-height: 1.6;
            margin-bottom: 1rem;
        }
        
        .demo-features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-top: 1.5rem;
        }
        
        .demo-feature {
            background: var(--color-surface-variant);
            padding: 1rem;
            border-radius: var(--border-radius-md);
            border-left: 4px solid var(--color-primary);
        }
        
        .demo-feature h4 {
            color: var(--color-primary);
            margin-bottom: 0.5rem;
            font-size: 1rem;
        }
        
        .demo-feature p {
            color: var(--color-text-secondary);
            font-size: 0.9rem;
            margin: 0;
        }
        
        .demo-code {
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 1rem;
            border-radius: var(--border-radius-md);
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            overflow-x: auto;
            margin: 1rem 0;
        }
        
        .demo-code .comment {
            color: #6a9955;
        }
        
        .demo-code .keyword {
            color: #569cd6;
        }
        
        .demo-code .string {
            color: #ce9178;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-content">
            <div class="logo">
                <i class="fas fa-robot"></i>
                <span><?= APP_NAME ?></span>
            </div>
            <div class="user-menu">
                <span><i class="fas fa-user-circle"></i> Demo User</span>
                <a href="#" class="btn btn-sm btn-outline">
                    <i class="fas fa-sign-out-alt"></i> Sair
                </a>
            </div>
        </div>
    </header>

    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <!-- Demo Content -->
    <main class="main-content">
        <div class="demo-content">
            <div class="demo-section">
                <h1 class="demo-title">🚀 Navbar Unificado</h1>
                <p class="demo-text">
                    O navbar foi criado para facilitar a navegação entre todas as páginas do sistema. 
                    Ele é responsivo, moderno e se adapta a diferentes tamanhos de tela.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile-alt"></i> Responsivo</h4>
                        <p>Funciona perfeitamente em desktop, tablet e mobile</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-palette"></i> Moderno</h4>
                        <p>Design limpo com gradientes e animações suaves</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-bolt"></i> Rápido</h4>
                        <p>Navegação instantânea entre páginas</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-shield-alt"></i> Seguro</h4>
                        <p>Integrado com sistema de autenticação</p>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">📱 Funcionalidades Mobile</h2>
                <p class="demo-text">
                    Em dispositivos móveis, o navbar se transforma em um menu hambúrguer que pode ser expandido/contraído.
                </p>
                
                <div class="demo-code">
<span class="comment">// JavaScript para controle do menu mobile</span>
<span class="keyword">function</span> <span class="string">toggleMobileMenu</span>() {
    <span class="keyword">const</span> menu = document.<span class="string">querySelector</span>(<span class="string">'.navbar-menu'</span>);
    <span class="keyword">const</span> toggle = document.<span class="string">querySelector</span>(<span class="string">'.navbar-toggle i'</span>);
    
    menu.<span class="string">classList</span>.<span class="string">toggle</span>(<span class="string">'active'</span>);
    
    <span class="keyword">if</span> (menu.<span class="string">classList</span>.<span class="string">contains</span>(<span class="string">'active'</span>)) {
        toggle.<span class="string">classList</span>.<span class="string">remove</span>(<span class="string">'fa-bars'</span>);
        toggle.<span class="string">classList</span>.<span class="string">add</span>(<span class="string">'fa-times'</span>);
    } <span class="keyword">else</span> {
        toggle.<span class="string">classList</span>.<span class="string">remove</span>(<span class="string">'fa-times'</span>);
        toggle.<span class="string">classList</span>.<span class="string">add</span>(<span class="string">'fa-bars'</span>);
    }
}
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🎨 Personalização</h2>
                <p class="demo-text">
                    O navbar pode ser facilmente personalizado através de variáveis CSS e classes utilitárias.
                </p>
                
                <div class="demo-code">
<span class="comment">/* Variáveis CSS para personalização */</span>
<span class="keyword">:root</span> {
    <span class="string">--color-primary</span>: <span class="string">#007bff</span>;
    <span class="string">--color-primary-dark</span>: <span class="string">#0056b3</span>;
    <span class="string">--border-radius-md</span>: <span class="string">8px</span>;
    <span class="string">--transition-base</span>: <span class="string">0.3s ease</span>;
}

<span class="comment">/* Estilos do navbar */</span>
.<span class="string">navbar</span> {
    <span class="string">background</span>: <span class="string">linear-gradient(135deg, var(--color-primary) 0%, var(--color-primary-dark) 100%)</span>;
    <span class="string">box-shadow</span>: <span class="string">0 2px 10px rgba(0, 0, 0, 0.1)</span>;
    <span class="string">position</span>: <span class="string">sticky</span>;
    <span class="string">top</span>: <span class="string">0</span>;
    <span class="string">z-index</span>: <span class="string">1000</span>;
}
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🔗 Como Usar</h2>
                <p class="demo-text">
                    Para usar o navbar em suas páginas, simplesmente inclua o arquivo <code>navbar.php</code>:
                </p>
                
                <div class="demo-code">
<span class="comment">&lt;!-- Incluir navbar em qualquer página --&gt;</span>
<span class="keyword">&lt;?php</span> <span class="string">include</span> <span class="string">'navbar.php'</span>; <span class="keyword">?&gt;</span>

<span class="comment">&lt;!-- O navbar detecta automaticamente a página atual --&gt;</span>
<span class="comment">&lt;!-- e marca o link correspondente como ativo --&gt;</span>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <p>&copy; <?= date('Y') ?> <?= APP_NAME ?> - Navbar Demo</p>
    </footer>
</body>
</html>
