<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Menu de Navegação Rápida - Demo</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/quick-nav.css">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
            background: var(--color-background);
        }
        
        .demo-content {
            padding: 2rem;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .demo-section {
            background: var(--color-surface);
            border-radius: var(--border-radius-lg);
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: var(--shadow-md);
        }
        
        .demo-title {
            color: var(--color-primary);
            margin-bottom: 1rem;
            font-size: 1.5rem;
            font-weight: 600;
        }
        
        .demo-text {
            color: var(--color-text-secondary);
            line-height: 1.6;
            margin-bottom: 1rem;
        }
        
        .demo-features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-top: 1.5rem;
        }
        
        .demo-feature {
            background: var(--color-surface-variant);
            padding: 1rem;
            border-radius: var(--border-radius-md);
            border-left: 4px solid var(--color-primary);
        }
        
        .demo-feature h4 {
            color: var(--color-primary);
            margin-bottom: 0.5rem;
            font-size: 1rem;
        }
        
        .demo-feature p {
            color: var(--color-text-secondary);
            font-size: 0.9rem;
            margin: 0;
        }
        
        .demo-code {
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 1rem;
            border-radius: var(--border-radius-md);
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            overflow-x: auto;
            margin: 1rem 0;
        }
        
        .demo-code .comment {
            color: #6a9955;
        }
        
        .demo-code .keyword {
            color: #569cd6;
        }
        
        .demo-code .string {
            color: #ce9178;
        }
        
        .demo-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .demo-header h1 {
            color: var(--color-primary);
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        
        .demo-header p {
            color: var(--color-text-secondary);
            font-size: 1.1rem;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-content">
            <div class="logo">
                <i class="fas fa-robot"></i>
                <span><?= APP_NAME ?></span>
            </div>
            <div class="user-menu">
                <span><i class="fas fa-user-circle"></i> Demo User</span>
                <a href="#" class="btn btn-sm btn-outline">
                    <i class="fas fa-sign-out-alt"></i> Sair
                </a>
            </div>
        </div>
    </header>

    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <!-- Demo Content -->
    <main class="main-content">
        <div class="demo-content">
            <div class="demo-header">
                <h1>🚀 Menu de Navegação Rápida</h1>
                <p>Demonstração do menu de acesso rápido às principais seções</p>
            </div>
            
            <!-- Quick Navigation Menu -->
            <div class="quick-nav">
                <div class="quick-nav-header">
                    <h2><i class="fas fa-rocket"></i> Navegação Rápida</h2>
                    <p>Acesse rapidamente as principais seções do sistema</p>
                </div>
                <div class="quick-nav-grid">
                    <a href="comentarios.php" class="quick-nav-item">
                        <div class="quick-nav-icon">
                            <i class="fas fa-history"></i>
                        </div>
                        <div class="quick-nav-content">
                            <h3>Histórico</h3>
                            <p>Visualizar histórico de comentários</p>
                        </div>
                    </a>
                    
                    <a href="comentarios_pendentes.php" class="quick-nav-item">
                        <div class="quick-nav-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="quick-nav-content">
                            <h3>Pendentes</h3>
                            <p>Comentários aguardando aprovação</p>
                        </div>
                    </a>
                    
                    <a href="comentarios_aprovados.php" class="quick-nav-item">
                        <div class="quick-nav-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div class="quick-nav-content">
                            <h3>Aprovados</h3>
                            <p>Comentários já aprovados</p>
                        </div>
                    </a>
                    
                    <a href="comentarios_maquinas.php" class="quick-nav-item">
                        <div class="quick-nav-icon">
                            <i class="fas fa-desktop"></i>
                        </div>
                        <div class="quick-nav-content">
                            <h3>Máquinas</h3>
                            <p>Status das máquinas do sistema</p>
                        </div>
                    </a>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">✨ Funcionalidades</h2>
                <p class="demo-text">
                    O menu de navegação rápida oferece acesso direto às principais seções do sistema com design moderno e responsivo.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile-alt"></i> Responsivo</h4>
                        <p>Se adapta automaticamente a diferentes tamanhos de tela</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-palette"></i> Moderno</h4>
                        <p>Design limpo com ícones e animações suaves</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-bolt"></i> Rápido</h4>
                        <p>Acesso instantâneo às principais funcionalidades</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-eye"></i> Intuitivo</h4>
                        <p>Interface clara e fácil de usar</p>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🎨 Estilos CSS</h2>
                <p class="demo-text">
                    O menu utiliza CSS Grid para layout responsivo e CSS customizado para animações e efeitos visuais.
                </p>
                
                <div class="demo-code">
<span class="comment">/* Grid responsivo */</span>
.<span class="string">quick-nav-grid</span> {
    <span class="string">display</span>: <span class="string">grid</span>;
    <span class="string">grid-template-columns</span>: <span class="string">repeat(auto-fit, minmax(250px, 1fr))</span>;
    <span class="string">gap</span>: <span class="string">1.5rem</span>;
}

<span class="comment">/* Efeitos hover */</span>
.<span class="string">quick-nav-item</span><span class="keyword">:hover</span> {
    <span class="string">transform</span>: <span class="string">translateY(-2px)</span>;
    <span class="string">box-shadow</span>: <span class="string">var(--shadow-lg)</span>;
    <span class="string">background</span>: <span class="string">var(--color-primary-light)</span>;
}

<span class="comment">/* Animações */</span>
.<span class="string">quick-nav-item</span> {
    <span class="string">animation</span>: <span class="string">fadeInUp 0.6s ease-out</span>;
}
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">📱 Responsividade</h2>
                <p class="demo-text">
                    O menu se adapta automaticamente a diferentes dispositivos, oferecendo a melhor experiência em cada um.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-desktop"></i> Desktop</h4>
                        <p>Grid de 4 colunas com ícones grandes</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-tablet-alt"></i> Tablet</h4>
                        <p>Grid de 2 colunas com espaçamento otimizado</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile-alt"></i> Mobile</h4>
                        <p>Layout de 1 coluna com ícones menores</p>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🔧 Como Implementar</h2>
                <p class="demo-text">
                    Para usar o menu de navegação rápida em suas páginas, siga estes passos:
                </p>
                
                <div class="demo-code">
<span class="comment">&lt;!-- 1. Incluir o CSS --&gt;</span>
<span class="keyword">&lt;link</span> <span class="string">rel</span>=<span class="string">"stylesheet"</span> <span class="string">href</span>=<span class="string">"assets/css/quick-nav.css"</span><span class="keyword">&gt;</span>

<span class="comment">&lt;!-- 2. Adicionar o HTML --&gt;</span>
<span class="keyword">&lt;div</span> <span class="string">class</span>=<span class="string">"quick-nav"</span><span class="keyword">&gt;</span>
    <span class="keyword">&lt;div</span> <span class="string">class</span>=<span class="string">"quick-nav-header"</span><span class="keyword">&gt;</span>
        <span class="keyword">&lt;h2</span><span class="keyword">&gt;</span><span class="string">Navegação Rápida</span><span class="keyword">&lt;/h2</span><span class="keyword">&gt;</span>
    <span class="keyword">&lt;/div</span><span class="keyword">&gt;</span>
    <span class="keyword">&lt;div</span> <span class="string">class</span>=<span class="string">"quick-nav-grid"</span><span class="keyword">&gt;</span>
        <span class="comment">&lt;!-- Itens do menu --&gt;</span>
    <span class="keyword">&lt;/div</span><span class="keyword">&gt;</span>
<span class="keyword">&lt;/div</span><span class="keyword">&gt;</span>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <p>&copy; <?= date('Y') ?> <?= APP_NAME ?> - Menu de Navegação Rápida Demo</p>
    </footer>
</body>
</html>
