<?php
require_once 'config.php';
requireLogin();

// Função auxiliar para exibir texto com emojis corretamente
function exibir_texto($texto) {
    return htmlspecialchars($texto, ENT_QUOTES, 'UTF-8');
}

// Configurar charset UTF-8 para suportar emojis
if (isset($conn) && $conn instanceof mysqli) {
    $conn->set_charset("utf8mb4");
}

// Verificar se é uma requisição POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método não permitido']);
    exit;
}

// Obter dados JSON
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!$data) {
    http_response_code(400);
    echo json_encode(['error' => 'Dados inválidos']);
    exit;
}

// Validar e sanitizar dados
$config = [
    'thresholds' => [],
    'negative_words' => [],
    'positive_words' => [],
    'timeouts' => []
];

// Processar thresholds
if (isset($data['thresholds']) && is_array($data['thresholds'])) {
    $valid_thresholds = ['TOXICITY', 'SEVERE_TOXICITY', 'INSULT', 'PROFANITY', 'THREAT', 'IDENTITY_ATTACK'];
    foreach ($valid_thresholds as $key) {
        if (isset($data['thresholds'][$key])) {
            $value = floatval($data['thresholds'][$key]);
            if ($value >= 0 && $value <= 1) {
                $config['thresholds'][$key] = $value;
            }
        }
    }
}

// Processar palavras negativas
if (isset($data['negative_words']) && is_array($data['negative_words'])) {
    $config['negative_words'] = array_filter(array_map('trim', $data['negative_words']));
}

// Processar palavras positivas
if (isset($data['positive_words']) && is_array($data['positive_words'])) {
    $config['positive_words'] = array_filter(array_map('trim', $data['positive_words']));
}

// Processar timeouts
if (isset($data['timeouts']) && is_array($data['timeouts'])) {
    $valid_timeouts = ['main_timeout', 'connect_timeout', 'fallback_timeout', 'fallback_connect_timeout'];
    foreach ($valid_timeouts as $key) {
        if (isset($data['timeouts'][$key])) {
            $value = intval($data['timeouts'][$key]);
            if ($value > 0 && $value <= 300) {
                $config['timeouts'][$key] = $value;
            }
        }
    }
}

// Salvar configuração
$config_file = 'comentario/ia_config.json';
$config_dir = dirname($config_file);

// Criar diretório se não existir
if (!is_dir($config_dir)) {
    mkdir($config_dir, 0755, true);
}

// Salvar arquivo
$result = file_put_contents($config_file, json_encode($config, JSON_PRETTY_PRINT));

if ($result === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Erro ao salvar configuração']);
    exit;
}

// Retornar sucesso
header('Content-Type: application/json');
echo json_encode(['success' => true, 'message' => 'Configuração salva com sucesso']);
?>
