<?php
// Teste de conexão e verificação da tabela
require_once 'config.php';

echo "<h2>Teste de Conexão e Tabela de Usuários</h2>";

// Testar conexão principal
if ($mysqli) {
    echo "✅ Conexão com banco principal (su_ma) OK<br>";
    
    // Verificar se a tabela users existe
    $result = $mysqli->query("SHOW TABLES LIKE 'users'");
    if ($result && $result->num_rows > 0) {
        echo "✅ Tabela 'users' existe<br>";
        
        // Contar usuários
        $count_result = $mysqli->query("SELECT COUNT(*) as count FROM users");
        $count = $count_result->fetch_assoc()['count'];
        echo "📊 Total de usuários: $count<br>";
        
        // Listar usuários
        $users_result = $mysqli->query("SELECT id, username, email, created_at FROM users");
        if ($users_result) {
            echo "<h3>Usuários cadastrados:</h3>";
            echo "<table border='1' style='border-collapse: collapse;'>";
            echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Data</th></tr>";
            while ($user = $users_result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $user['id'] . "</td>";
                echo "<td>" . htmlspecialchars($user['username']) . "</td>";
                echo "<td>" . htmlspecialchars($user['email']) . "</td>";
                echo "<td>" . $user['created_at'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    } else {
        echo "❌ Tabela 'users' NÃO existe<br>";
        echo "<a href='create_users_table.php'>Clique aqui para criar a tabela</a><br>";
    }
} else {
    echo "❌ Erro de conexão com banco principal<br>";
}

// Testar conexão de comentários
if ($conn) {
    echo "✅ Conexão com banco de comentários (su_co) OK<br>";
} else {
    echo "❌ Erro de conexão com banco de comentários<br>";
}

echo "<br><a href='admin_register'>Testar página de cadastro</a><br>";
echo "<a href='login'>Ir para login</a><br>";
?>
