<?php
require_once 'config.php';

$errors = [];
$success = false;

// Processar o formulário quando enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validar e obter dados do formulário
    $maquina = trim($_POST['maquina'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $profile = trim($_POST['profile'] ?? '');
    $orderid = !empty($_POST['orderid']) ? (int)$_POST['orderid'] : null;
    $link = trim($_POST['link'] ?? '');
    $comment = trim($_POST['comment'] ?? '');
    $status = trim($_POST['status'] ?? '');
    
    // Validações
    if (empty($maquina)) {
        $errors[] = "O campo Máquina é obrigatório";
    }
    
    if (empty($username)) {
        $errors[] = "O campo Usuário é obrigatório";
    }
    
    if (empty($profile)) {
        $errors[] = "O campo Perfil é obrigatório";
    }
    
    if (empty($link)) {
        $errors[] = "O campo Link é obrigatório";
    }
    
    if (empty($comment)) {
        $errors[] = "O campo Comentário é obrigatório";
    }
    
    // Se não houver erros, inserir no banco de dados
    if (empty($errors)) {
        // Preparar a consulta SQL
        $sql = "INSERT INTO history (maquina, username, profile, data_acao, orderid, link, comment, status) VALUES (?, ?, ?, NOW(), ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssisss", $maquina, $username, $profile, $orderid, $link, $comment, $status);
        
        // Executar a consulta
        if ($stmt->execute()) {
            $success = true;
        } else {
            $errors[] = "Erro ao salvar o registro: " . $conn->error;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Comentários</title>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-content">
                <h1 class="header-title">
                    <i class="fas fa-plus-circle"></i>Novo Registro
                </h1>
                <a href="index" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left"></i>Voltar
                </a>
            </div>
        </div>
    </header>

    <main class="page-container">
        <?php if ($success): ?>
            <div class="alert alert-success alert-dismissible">
                <i class="fas fa-check-circle me-2"></i>Registro adicionado com sucesso!
                <a href="index" class="text-success">Voltar à lista</a>
                <button type="button" class="btn-close" onclick="this.parentElement.style.display='none';" aria-label="Fechar"></button>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($errors)): ?>
            <div class="alert alert-danger alert-dismissible">
                <i class="fas fa-exclamation-circle me-2"></i>
                <strong>Ocorreram os seguintes erros:</strong>
                <ul class="mb-0 mt-2">
                    <?php foreach ($errors as $error): ?>
                        <li><?php echo $error; ?></li>
                    <?php endforeach; ?>
                </ul>
                <button type="button" class="btn-close" onclick="this.parentElement.style.display='none';" aria-label="Fechar"></button>
            </div>
        <?php endif; ?>
        
        <section class="card">
            <div class="card-header">
                <h2 class="card-title">Informações do Registro</h2>
            </div>
            <div class="card-body">
                <form method="POST" action="" id="addForm">
                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label for="maquina" class="form-label">Máquina *</label>
                                <input type="text" class="form-control" id="maquina" name="maquina" required 
                                       value="<?php echo htmlspecialchars($_POST['maquina'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label for="username" class="form-label">Usuário *</label>
                                <input type="text" class="form-control" id="username" name="username" required 
                                       value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label for="profile" class="form-label">Perfil *</label>
                                <input type="text" class="form-control" id="profile" name="profile" required 
                                       value="<?php echo htmlspecialchars($_POST['profile'] ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label for="orderid" class="form-label">Order ID</label>
                                <input type="number" class="form-control" id="orderid" name="orderid" 
                                       value="<?php echo htmlspecialchars($_POST['orderid'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="form-col">
                            <div class="form-group">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="" selected>Selecione um status</option>
                                    <option value="Completo" <?php echo (isset($_POST['status']) && $_POST['status'] == 'Completo') ? 'selected' : ''; ?>>Completo</option>
                                    <option value="Erro" <?php echo (isset($_POST['status']) && $_POST['status'] == 'Erro') ? 'selected' : ''; ?>>Erro</option>
                                    <option value="Pendente" <?php echo (isset($_POST['status']) && $_POST['status'] == 'Pendente') ? 'selected' : ''; ?>>Pendente</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="link" class="form-label">Link *</label>
                        <input type="url" class="form-control" id="link" name="link" required 
                               value="<?php echo htmlspecialchars($_POST['link'] ?? ''); ?>">
                    </div>
                    
                    <div class="form-group">
                        <label for="comment" class="form-label">Comentário *</label>
                        <textarea class="form-control" id="comment" name="comment" rows="5" required><?php echo htmlspecialchars($_POST['comment'] ?? ''); ?></textarea>
                    </div>
                </form>
            </div>
            <div class="card-footer d-flex justify-content-between">
                <a href="index" class="btn btn-secondary">
                    <i class="fas fa-times"></i>Cancelar
                </a>
                <button type="submit" form="addForm" class="btn btn-success">
                    <i class="fas fa-save"></i>Salvar Registro
                </button>
            </div>
        </section>
    </main>

    <footer class="text-center mt-4 mb-4 text-muted">
        <small>&copy; <?php echo date('Y'); ?> - Sistema de Histórico</small>
    </footer>
</body>
</html> 