<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: pendentes.php');
    exit();
}

$id = isset($_POST['id']) ? intval($_POST['id']) : 0;
$source = isset($_POST['source']) ? preg_replace('/[^a-zA-Z0-9_]/', '', $_POST['source']) : '';
$action = isset($_POST['action']) ? $_POST['action'] : '';

// Fluxo por ação
if ($action === 'bulk') {
    $ids = isset($_POST['ids']) && is_array($_POST['ids']) ? array_map('intval', $_POST['ids']) : [];
    $sources = isset($_POST['sources']) && is_array($_POST['sources']) ? $_POST['sources'] : [];
    $bulkAction = isset($_POST['bulk_action']) ? $_POST['bulk_action'] : '';
    foreach ($ids as $oneId) {
        $tbl = isset($sources[$oneId]) ? preg_replace('/[^a-zA-Z0-9_]/', '', $sources[$oneId]) : '';
        if (!in_array($tbl, ['comments', 'commentsaleatorio'])) { continue; }
        if ($bulkAction === 'approve') {
            $stmt = $conn->prepare("UPDATE `$tbl` SET approved = 1 WHERE id = ?");
            if ($stmt) { $stmt->bind_param('i', $oneId); $stmt->execute(); $stmt->close(); }
        } elseif ($bulkAction === 'reject') {
            $stmt = $conn->prepare("DELETE FROM `$tbl` WHERE id = ?");
            if ($stmt) { $stmt->bind_param('i', $oneId); $stmt->execute(); $stmt->close(); }
        }
    }
    header('Location: pendentes.php');
    exit();
}

if ($action === 'approve_link') {
    $link = isset($_POST['link']) ? $_POST['link'] : '';
    $src = isset($_POST['source']) ? preg_replace('/[^a-zA-Z0-9_]/', '', $_POST['source']) : '';
    if (!empty($link) && in_array($src, ['comments', 'commentsaleatorio'])) {
        $stmt = $conn->prepare("UPDATE `$src` SET approved = 1 WHERE link = ?");
        if ($stmt) { $stmt->bind_param('s', $link); $stmt->execute(); $stmt->close(); }
    }
    header('Location: pendentes.php');
    exit();
}

if ($action === 'reject_link') {
    $link = isset($_POST['link']) ? $_POST['link'] : '';
    $src = isset($_POST['source']) ? preg_replace('/[^a-zA-Z0-9_]/', '', $_POST['source']) : '';
    if (!empty($link) && in_array($src, ['comments', 'commentsaleatorio'])) {
        $stmt = $conn->prepare("DELETE FROM `$src` WHERE link = ?");
        if ($stmt) { $stmt->bind_param('s', $link); $stmt->execute(); $stmt->close(); }
    }
    header('Location: aprovados.php');
    exit();
}

if ($id <= 0 || !in_array($source, ['comments', 'commentsaleatorio'])) {
    header('Location: pendentes.php');
    exit();
}

// Aprovar = approved = 1; Rejeitar = excluir linha
if ($action === 'approve') {
    $stmt = $conn->prepare("UPDATE `$source` SET approved = 1 WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->close();
    }
} elseif ($action === 'reject') {
    $stmt = $conn->prepare("DELETE FROM `$source` WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->close();
    }
}

header('Location: pendentes.php');
exit();
?>


