<?php
// Debug para identificar comentários problemáticos
require_once 'ia_analyze.php';

// Simular alguns comentários problemáticos
$test_comments = [
    "Este é um comentário normal",
    "", // Comentário vazio
    "a", // Muito curto
    str_repeat("a", 3000), // Muito longo
    "Comentário com caracteres especiais: @#$%^&*()",
    "Comentário com emojis: 😀😁😂🤣😃😄😅😆",
    "Comentário com acentos: áéíóú àèìòù âêîôû",
    "Comentário com números: 123456789",
    "Comentário misto: Olá 123 @#$ 😀",
];

echo "<h1>Debug de Comentários</h1>";

foreach ($test_comments as $i => $comment) {
    echo "<h3>Teste " . ($i + 1) . ":</h3>";
    echo "<p><strong>Comentário:</strong> " . htmlspecialchars($comment) . "</p>";
    echo "<p><strong>Tamanho:</strong> " . strlen($comment) . " caracteres</p>";
    
    // Testar análise
    $payload = json_encode(['comment' => $comment]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'http://localhost/comentario/ia_analyze.php');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($code === 200 && $resp) {
        $data = json_decode($resp, true);
        $result = $data['result'] ?? ['color' => 'error', 'label' => 'Sem resultado'];
        echo "<p><strong>Resultado:</strong> <span style='color: " . ($result['color'] === 'risk-red' ? 'red' : 
                                                                    $result['color'] === 'risk-green' ? 'green' : 
                                                                    $result['color'] === 'risk-blue' ? 'blue' : 'orange') . ";'>" . 
             $result['label'] . "</span></p>";
        echo "<p><strong>Detalhes:</strong> " . htmlspecialchars($result['detail']) . "</p>";
    } else {
        echo "<p style='color: red;'><strong>ERRO:</strong> HTTP $code</p>";
    }
    
    echo "<hr>";
}
?>
