<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Design Corrigido - Demo</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/base.css">
    <link rel="stylesheet" href="assets/css/navbar.css">
    <link rel="stylesheet" href="assets/css/main-content.css">
    <link rel="stylesheet" href="assets/css/quick-nav.css">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
            background: #f8f9fa;
        }
        
        .demo-content {
            padding: 2rem;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .demo-section {
            background: #ffffff;
            border-radius: 12px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border: 1px solid #dee2e6;
        }
        
        .demo-title {
            color: #007bff;
            margin-bottom: 1rem;
            font-size: 1.5rem;
            font-weight: 600;
        }
        
        .demo-text {
            color: #6c757d;
            line-height: 1.6;
            margin-bottom: 1rem;
        }
        
        .demo-features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-top: 1.5rem;
        }
        
        .demo-feature {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 8px;
            border-left: 4px solid #007bff;
        }
        
        .demo-feature h4 {
            color: #007bff;
            margin-bottom: 0.5rem;
            font-size: 1rem;
        }
        
        .demo-feature p {
            color: #6c757d;
            font-size: 0.9rem;
            margin: 0;
        }
        
        .demo-code {
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 1rem;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            overflow-x: auto;
            margin: 1rem 0;
        }
        
        .demo-code .comment {
            color: #6a9955;
        }
        
        .demo-code .keyword {
            color: #569cd6;
        }
        
        .demo-code .string {
            color: #ce9178;
        }
        
        .demo-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .demo-header h1 {
            color: #007bff;
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        
        .demo-header p {
            color: #6c757d;
            font-size: 1.1rem;
        }
        
        .demo-comparison {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin: 2rem 0;
        }
        
        .demo-before,
        .demo-after {
            padding: 1.5rem;
            border-radius: 8px;
            border: 2px solid;
        }
        
        .demo-before {
            background: #ffe6e6;
            border-color: #ff6b6b;
        }
        
        .demo-after {
            background: #e6ffe6;
            border-color: #51cf66;
        }
        
        .demo-before h3 {
            color: #ff6b6b;
            margin-bottom: 1rem;
        }
        
        .demo-after h3 {
            color: #51cf66;
            margin-bottom: 1rem;
        }
        
        .demo-before ul,
        .demo-after ul {
            margin: 0;
            padding-left: 1.5rem;
        }
        
        .demo-before li,
        .demo-after li {
            margin-bottom: 0.5rem;
            color: #333;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <!-- Demo Content -->
    <main class="main-content">
        <div class="demo-content">
            <div class="demo-header">
                <h1>🎨 Design Corrigido</h1>
                <p>Interface limpa e com excelente contraste - Problemas de visibilidade resolvidos</p>
            </div>
            
            <!-- Quick Navigation Menu -->
            <div class="quick-nav">
                <div class="quick-nav-header">
                    <h2><i class="fas fa-rocket"></i> Navegação Rápida</h2>
                    <p>Acesse rapidamente as principais seções do sistema</p>
                </div>
                <div class="quick-nav-grid">
                    <a href="comentarios.php" class="quick-nav-item">
                        <div class="quick-nav-icon">
                            <i class="fas fa-history"></i>
                        </div>
                        <div class="quick-nav-content">
                            <h3>Histórico</h3>
                            <p>Visualizar histórico de comentários</p>
                        </div>
                    </a>
                    
                    <a href="comentarios_pendentes.php" class="quick-nav-item">
                        <div class="quick-nav-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="quick-nav-content">
                            <h3>Pendentes</h3>
                            <p>Comentários aguardando aprovação</p>
                        </div>
                    </a>
                    
                    <a href="comentarios_aprovados.php" class="quick-nav-item">
                        <div class="quick-nav-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div class="quick-nav-content">
                            <h3>Aprovados</h3>
                            <p>Comentários já aprovados</p>
                        </div>
                    </a>
                    
                    <a href="comentarios_maquinas.php" class="quick-nav-item">
                        <div class="quick-nav-icon">
                            <i class="fas fa-desktop"></i>
                        </div>
                        <div class="quick-nav-content">
                            <h3>Máquinas</h3>
                            <p>Status das máquinas do sistema</p>
                        </div>
                    </a>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">✨ Problemas Resolvidos</h2>
                <p class="demo-text">
                    O design foi completamente corrigido para resolver os problemas de contraste e visibilidade.
                </p>
                
                <div class="demo-comparison">
                    <div class="demo-before">
                        <h3>❌ Antes</h3>
                        <ul>
                            <li>Contraste muito baixo</li>
                            <li>Texto quase invisível</li>
                            <li>Cores muito claras</li>
                            <li>Elementos difíceis de ler</li>
                            <li>Design fragmentado</li>
                        </ul>
                    </div>
                    
                    <div class="demo-after">
                        <h3>✅ Depois</h3>
                        <ul>
                            <li>Contraste excelente</li>
                            <li>Texto bem visível</li>
                            <li>Cores vibrantes</li>
                            <li>Elementos claros</li>
                            <li>Design integrado</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🎨 Melhorias de Design</h2>
                <p class="demo-text">
                    O novo design oferece uma experiência visual muito melhor com cores bem definidas e contraste adequado.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-palette"></i> Cores Definidas</h4>
                        <p>Cores específicas em vez de variáveis CSS não definidas</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-eye"></i> Contraste Excelente</h4>
                        <p>Texto escuro em fundos claros para máxima legibilidade</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile-alt"></i> Responsivo</h4>
                        <p>Design que funciona perfeitamente em todos os dispositivos</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-paint-brush"></i> Moderno</h4>
                        <p>Interface limpa e profissional</p>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🔧 Correções Implementadas</h2>
                <p class="demo-text">
                    As principais correções foram aplicadas para resolver os problemas de visibilidade.
                </p>
                
                <div class="demo-code">
<span class="comment">/* Cores definidas explicitamente */</span>
.<span class="string">quick-nav</span> {
    <span class="string">background</span>: <span class="string">#ffffff</span>;
    <span class="string">border</span>: <span class="string">1px solid #dee2e6</span>;
    <span class="string">box-shadow</span>: <span class="string">0 4px 6px rgba(0, 0, 0, 0.1)</span>;
}

.<span class="string">quick-nav-item</span> {
    <span class="string">background</span>: <span class="string">#f8f9fa</span>;
    <span class="string">color</span>: <span class="string">#212529</span>;
    <span class="string">border</span>: <span class="string">1px solid #dee2e6</span>;
}

.<span class="string">quick-nav-content h3</span> {
    <span class="string">color</span>: <span class="string">inherit</span>;
    <span class="string">font-weight</span>: <span class="string">600</span>;
}

.<span class="string">quick-nav-content p</span> {
    <span class="string">color</span>: <span class="string">#6c757d</span>;
}
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">📱 Responsividade</h2>
                <p class="demo-text">
                    O design se adapta perfeitamente a diferentes tamanhos de tela, mantendo a legibilidade em todos os dispositivos.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-desktop"></i> Desktop</h4>
                        <p>Grid de 4 colunas com espaçamento generoso</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-tablet-alt"></i> Tablet</h4>
                        <p>Grid adaptativo com 2-3 colunas</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile-alt"></i> Mobile</h4>
                        <p>Layout de 1 coluna com elementos otimizados</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-eye"></i> Acessibilidade</h4>
                        <p>Contraste adequado e elementos focáveis</p>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🚀 Benefícios</h2>
                <p class="demo-text">
                    O design corrigido oferece uma experiência muito melhor para os usuários.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-eye"></i> Legibilidade</h4>
                        <p>Texto claro e fácil de ler</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-palette"></i> Visual</h4>
                        <p>Interface moderna e atrativa</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-users"></i> UX</h4>
                        <p>Experiência do usuário melhorada</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile-alt"></i> Responsivo</h4>
                        <p>Funciona perfeitamente em todos os dispositivos</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <p>&copy; <?= date('Y') ?> <?= APP_NAME ?> - Design Corrigido Demo</p>
    </footer>
</body>
</html>
