<?php
require_once 'config.php';
requireLogin();

// Processar ações
if (isset($_POST['navegadores']) && isset($_POST['acoesnum']) && isset($_POST['usuariofake']) && isset($_POST['rolagens']) && isset($_POST['maquinaid'])) {
    $maquina = 0;
    $navegadores = (int)$_POST['navegadores'];
    $acoesnum = (int)$_POST['acoesnum'];
    $usuariofake = $mysqli->real_escape_string($_POST['usuariofake']);
    $rolagens = (int)$_POST['rolagens'];
    $maquina = $_POST['maquinaid'];
    $maquinas = explode(",", $maquina);
    
    if ($maquina == 0) {
        $mysqli->query("DELETE FROM configs WHERE maquina != 0");
    }
    
    foreach ($maquinas as $idmaquina) {
        $idmaquina = (int)$idmaquina;
        $mysqli->query("INSERT INTO configs (maquina,navegadores,acoes,usuariofake,rolagens) VALUES ($idmaquina,$navegadores,$acoesnum,'$usuariofake',$rolagens) ON DUPLICATE KEY UPDATE navegadores = $navegadores, acoes = $acoesnum, usuariofake = '$usuariofake', rolagens = $rolagens");
    }
    
    $success_message = "Configurações salvas com sucesso!";
}

// Processar ações de máquinas
if (isset($_GET['acao']) && isset($_GET['id'])) {
    $acao = $_GET['acao'];
    $id = $mysqli->real_escape_string($_GET['id']);
    
    switch ($acao) {
        case 'reiniciar':
            $mysqli->query("UPDATE `$id` SET logged = 0, error = 0, errortext = NULL");
            header("Location: index.php?msg=reiniciado");
            exit;
            break;
            
        case 'reiniciarbons':
            $mysqli->query("UPDATE `$id` SET logged = 0, error = 0, errortext = NULL WHERE error IN (0, 1, 6, 9)");
            header("Location: index.php?msg=reiniciado_bons");
            exit;
            break;
            
        case 'removerinvalidas':
            $mysqli->query("DELETE FROM `$id` WHERE error = 3 OR error = 5");
            header("Location: index.php?msg=removido_invalidas");
            exit;
            break;
            
        case 'removerbloqueadas':
            $mysqli->query("DELETE FROM `$id` WHERE error = 4");
            header("Location: index.php?msg=removido_bloqueadas");
            exit;
            break;
            
        case 'removermaquina':
            $mysqli->query("DROP TABLE IF EXISTS `$id`");
            $numero_maquina = str_replace('maquina_', '', $id);
            $mysqli->query("DELETE FROM configs WHERE maquina = $numero_maquina");
            header("Location: index.php?msg=maquina_removida");
            exit;
            break;
    }
}

// Processar ações em massa
if (isset($_GET['acao'])) {
    $acao = $_GET['acao'];
    
    switch ($acao) {
        case 'reiniciartodos':
            $result = $mysqli->query("SHOW TABLES LIKE 'maquina_%'");
            while ($row = $result->fetch_array()) {
                $table = $row[0];
                $mysqli->query("UPDATE `$table` SET error=0, errortext=NULL, logged=0");
            }
            header("Location: index.php?msg=todos_reiniciados");
            exit;
            break;
            
        case 'reiniciarbonstodos':
            $result = $mysqli->query("SHOW TABLES LIKE 'maquina_%'");
            while ($row = $result->fetch_array()) {
                $table = $row[0];
                $mysqli->query("UPDATE `$table` SET error=0, errortext=NULL, logged=0 WHERE error IN (0, 1, 6, 9)");
            }
            header("Location: index.php?msg=bons_reiniciados");
            exit;
            break;
            
        case 'removertodos':
            $result = $mysqli->query("SHOW TABLES LIKE 'maquina_%'");
            while ($row = $result->fetch_array()) {
                $table = $row[0];
                $mysqli->query("DELETE FROM `$table` WHERE error IN (3, 5)");
            }
            header("Location: index.php?msg=invalidas_removidas");
            exit;
            break;
            
        case 'apagartodas':
            $result = $mysqli->query("SHOW TABLES LIKE 'maquina_%'");
            while ($row = $result->fetch_array()) {
                $table = $row[0];
                $mysqli->query("DROP TABLE `$table`");
            }
            $mysqli->query("DELETE FROM configs WHERE maquina > 0");
            header("Location: index.php?msg=todas_apagadas");
            exit;
            break;
    }
}

// Upload de cookies
if (isset($_POST['carregar'])) {
    $sexo = 0;
    $maquina_num = (int)$_POST['maquina'];
    $option = (int)$_POST['option'];
    
    if (isset($_FILES['fileUpload']) && $_FILES['fileUpload']['error'] === UPLOAD_ERR_OK) {
        $file_handle = fopen($_FILES['fileUpload']['tmp_name'], "r");
        $texto = '';
        while ($row = fgets($file_handle)) {
            $texto .= $row;
        }
        fclose($file_handle);
        
        $teste = explode("]", $texto);
        
        if ($option == 1) {
            $mysqli->query("DROP TABLE IF EXISTS maquina_$maquina_num");
        }
        
        $mysqli->query("CREATE TABLE IF NOT EXISTS `maquina_$maquina_num` (
            `id` int(0) NOT NULL AUTO_INCREMENT,
            `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',  
            `gender` int(0) NOT NULL DEFAULT 0,
            `cookie_token` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
            `last_login` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
            `logged` int(0) NOT NULL DEFAULT 0,  
            `error` int(0) NOT NULL DEFAULT 0,
            `errortext` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,    
            `ultima_acao` datetime(0) NULL DEFAULT NULL,
            `date_added` datetime(0) NULL DEFAULT NULL,  
            PRIMARY KEY (`id`) USING BTREE,  
            INDEX `error`(`error`) USING BTREE,       
            INDEX `dba_username_userid`(`username`) USING BTREE 
        ) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic");
        
        foreach ($teste as $cookie) {
            $cookie = $cookie . ']';
            $cookie = addslashes($cookie);
            if (!empty(trim($cookie)) && $cookie != ']') {
                $mysqli->query("INSERT INTO maquina_$maquina_num (username, gender, cookie_token, date_added) VALUES ('undefined', $sexo, '$cookie', NOW())");
            }
        }
        
        $mysqli->query("UPDATE maquina_$maquina_num SET cookie_token=REPLACE(cookie_token,'\r','')");      
        $mysqli->query("UPDATE maquina_$maquina_num SET cookie_token=REPLACE(cookie_token,'\n','')");      
        $mysqli->query("UPDATE maquina_$maquina_num SET cookie_token=REPLACE(cookie_token,'https://www.instagram.com','')");
        $mysqli->query("DELETE FROM maquina_$maquina_num WHERE cookie_token = '' OR cookie_token=']'");
        $mysqli->query("UPDATE maquina_$maquina_num SET cookie_token = (SUBSTR(cookie_token, INSTR(cookie_token, '[')))");
        
        $upload_success = "Perfis cadastrados com sucesso na máquina $maquina_num!";
    } else {
        $upload_error = "Erro no upload do arquivo!";
    }
}

// Buscar máquinas existentes (apenas as com número válido: maquina_1, maquina_2, ...)
// Evita incluir tabelas sem número (ex: 'maquina_') e ignora 'maquina_0'
$maquinas_query = $mysqli->query(
    "SELECT REPLACE(TABLE_NAME,'maquina_','') AS maquinas
     FROM INFORMATION_SCHEMA.TABLES
     WHERE TABLE_SCHEMA = '" . DB_NAME . "'
       AND TABLE_NAME REGEXP '^maquina_[1-9][0-9]*$'
     ORDER BY CAST(REPLACE(TABLE_NAME,'maquina_','') AS UNSIGNED) ASC"
);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/page-width.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #2563eb;
            --primary-dark: #1d4ed8;
            --primary-light: #dbeafe;
            --success-color: #10b981;
            --warning-color: #f59e0b;
            --danger-color: #ef4444;
            --info-color: #06b6d4;
            --secondary-color: #6b7280;
            --surface-color: #ffffff;
            --surface-variant: #f8fafc;
            --border-color: #e5e7eb;
            --text-primary: #111827;
            --text-secondary: #6b7280;
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --border-radius: 0.5rem;
            --border-radius-lg: 0.75rem;
            --transition: all 0.2s ease-in-out;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: var(--text-primary);
        }

        .main-content {
            padding: 2rem;
            max-width: 1400px;
            margin: 2rem auto 0 auto;
        }


        .page-title {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .page-subtitle {
            font-size: 1.2rem;
            opacity: 0.9;
            font-weight: 400;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 2rem;
            margin-bottom: 3rem;
        }

        .card {
            background: var(--surface-color);
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-lg);
            overflow: hidden;
            transition: var(--transition);
            border: 1px solid var(--border-color);
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        }

        .card-header {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 1.5rem;
            border-bottom: none;
        }

        .card-header h2 {
            font-size: 1.5rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .card-header i {
            font-size: 1.25rem;
        }

        .card-body {
            padding: 2rem;
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-group label {
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: var(--text-primary);
            font-size: 0.9rem;
        }

        .form-control {
            padding: 0.75rem 1rem;
            border: 2px solid var(--border-color);
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: var(--transition);
            background: var(--surface-color);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px var(--primary-light);
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: var(--border-radius);
            font-weight: 600;
            font-size: 1rem;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            text-decoration: none;
        }

        .btn-primary {
            background: var(--primary-color);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
        }

        .btn-success {
            background: var(--success-color);
            color: white;
        }

        .btn-success:hover {
            background: #059669;
            transform: translateY(-1px);
        }

        .btn-danger {
            background: var(--danger-color);
            color: white;
        }

        .btn-danger:hover {
            background: #dc2626;
            transform: translateY(-1px);
        }

        .btn-warning {
            background: var(--warning-color);
            color: white;
        }

        .btn-warning:hover {
            background: #d97706;
            transform: translateY(-1px);
        }

        .btn-info {
            background: var(--info-color);
            color: white;
        }

        .btn-info:hover {
            background: #0891b2;
            transform: translateY(-1px);
        }

        .btn-secondary {
            background: var(--secondary-color);
            color: white;
        }

        .btn-secondary:hover {
            background: #4b5563;
            transform: translateY(-1px);
        }

        .btn-sm {
            padding: 0.5rem 1rem;
            font-size: 0.875rem;
        }

        .table-responsive {
            overflow-x: auto;
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            background: var(--surface-color);
            table-layout: fixed;
        }

        /* Layout moderno da tabela de máquinas */
        .machines-container {
            background: var(--surface-color);
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-lg);
            overflow: hidden;
            border: 1px solid var(--border-color);
        }

        .machines-header {
            background: linear-gradient(135deg, #1e293b, #334155);
            color: white;
            padding: 2rem;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .machines-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
            opacity: 0.3;
        }

        .machines-header h2 {
            font-size: 2rem;
            font-weight: 700;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 1rem;
            position: relative;
            z-index: 1;
        }

        .machines-header i {
            font-size: 2rem;
            color: #60a5fa;
        }

        .machines-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            padding: 2rem;
            background: var(--surface-variant);
            border-bottom: 1px solid var(--border-color);
        }

        .stat-card {
            background: var(--surface-color);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            text-align: center;
            box-shadow: var(--shadow-sm);
            border: 1px solid var(--border-color);
            transition: var(--transition);
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        .stat-number {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .stat-label {
            font-size: 0.875rem;
            color: var(--text-secondary);
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .stat-success { color: var(--success-color); }
        .stat-warning { color: var(--warning-color); }
        .stat-danger { color: var(--danger-color); }
        .stat-info { color: var(--info-color); }
        .stat-primary { color: var(--primary-color); }

        .table-container {
            overflow-x: auto;
            background: var(--surface-color);
        }

        .machines-table {
            width: 100%;
            border-collapse: collapse;
            background: var(--surface-color);
            min-width: 1200px;
        }

        .machines-table th {
            background: linear-gradient(135deg, #f8fafc, #e2e8f0);
            padding: 1.25rem 1rem;
            text-align: center;
            font-weight: 600;
            color: var(--text-primary);
            border-bottom: 2px solid var(--border-color);
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .machines-table td {
            padding: 1rem;
            border-bottom: 1px solid var(--border-color);
            vertical-align: middle;
            text-align: center;
            font-size: 0.9rem;
        }

        .machines-table tr:hover {
            background: linear-gradient(90deg, var(--surface-variant), transparent);
        }

        .machine-number {
            font-weight: 700;
            font-size: 1.1rem;
            color: var(--primary-color);
            background: var(--primary-light);
            padding: 0.5rem 1rem;
            border-radius: var(--border-radius);
            display: inline-block;
        }

        .total-row {
            background: linear-gradient(135deg, #f0f9ff, #e0f2fe) !important;
            font-weight: 600;
            border-top: 3px solid var(--primary-color);
        }

        .total-row td {
            border-bottom: 2px solid var(--primary-color) !important;
            font-weight: 700;
        }

        .total-row .machine-number {
            background: var(--primary-color);
            color: white;
            font-size: 1.2rem;
        }

        .badge {
            padding: 0.5rem 1rem;
            border-radius: var(--border-radius);
            font-size: 0.875rem;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
            min-width: 2.5rem;
            justify-content: center;
            box-shadow: var(--shadow-sm);
            border: 1px solid transparent;
            transition: var(--transition);
        }

        .badge:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }

        .badge-primary { 
            background: linear-gradient(135deg, var(--primary-light), #dbeafe); 
            color: var(--primary-color); 
            border-color: var(--primary-color);
        }
        .badge-success { 
            background: linear-gradient(135deg, #dcfce7, #bbf7d0); 
            color: #166534; 
            border-color: #16a34a;
        }
        .badge-warning { 
            background: linear-gradient(135deg, #fef3c7, #fde68a); 
            color: #92400e; 
            border-color: #f59e0b;
        }
        .badge-danger { 
            background: linear-gradient(135deg, #fee2e2, #fecaca); 
            color: #991b1b; 
            border-color: #ef4444;
        }
        .badge-info { 
            background: linear-gradient(135deg, #e0f2fe, #bae6fd); 
            color: #0c4a6e; 
            border-color: #06b6d4;
        }
        .badge-secondary { 
            background: linear-gradient(135deg, #f3f4f6, #e5e7eb); 
            color: #374151; 
            border-color: #6b7280;
        }
        .badge-orange { 
            background: linear-gradient(135deg, #fed7aa, #fdba74); 
            color: #9a3412; 
            border-color: #f97316;
        }

        .btn-group {
            display: flex;
            gap: 0.5rem;
            flex-wrap: wrap;
            justify-content: flex-start;
            width: 100%;
        }

        /* Botões de ação na tabela */
        .machines-table .btn-group {
            gap: 0.5rem;
            justify-content: center;
            flex-wrap: wrap;
        }

        .machines-table .btn-group .btn {
            padding: 0.5rem 0.75rem;
            font-size: 0.8rem;
            min-width: auto;
            white-space: nowrap;
            border-radius: var(--border-radius);
            font-weight: 600;
            transition: var(--transition);
            box-shadow: var(--shadow-sm);
        }

        .machines-table .btn-group .btn:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }

        .machines-table .btn-group .btn span {
            display: inline;
            margin-left: 0.25rem;
        }

        .machines-table .btn-group .btn i {
            font-size: 0.9rem;
        }

        /* Botões específicos para máquinas */
        .btn-machine-success {
            background: linear-gradient(135deg, var(--success-color), #059669);
            color: white;
            border: 1px solid var(--success-color);
        }

        .btn-machine-info {
            background: linear-gradient(135deg, var(--info-color), #0891b2);
            color: white;
            border: 1px solid var(--info-color);
        }

        .btn-machine-warning {
            background: linear-gradient(135deg, var(--warning-color), #d97706);
            color: white;
            border: 1px solid var(--warning-color);
        }

        .btn-machine-orange {
            background: linear-gradient(135deg, #f97316, #ea580c);
            color: white;
            border: 1px solid #f97316;
        }

        .btn-machine-danger {
            background: linear-gradient(135deg, var(--danger-color), #dc2626);
            color: white;
            border: 1px solid var(--danger-color);
        }

        /* Correção para botões desabilitados */
        .btn:disabled {
            opacity: 1;
            background: #6c757d !important;
            color: white !important;
            border: none !important;
            cursor: default !important;
        }

        .btn:disabled:hover {
            background: #6c757d !important;
            transform: none !important;
        }

        .action-buttons {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
            justify-content: center;
            margin-top: 2rem;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: var(--border-radius);
            margin-bottom: 2rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-weight: 500;
        }

        .alert-success {
            background: #dcfce7;
            color: #166534;
            border: 1px solid #bbf7d0;
        }

        .alert-error {
            background: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
        }

        .total-row {
            background: linear-gradient(135deg, var(--primary-light), #e0f2fe) !important;
            font-weight: 600;
        }

        .total-row td {
            border-bottom: 2px solid var(--primary-color) !important;
        }

        .radio-label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: var(--border-radius);
            transition: var(--transition);
        }

        .radio-label:hover {
            background: var(--surface-variant);
        }

        .radio-label input[type="radio"] {
            margin: 0;
        }

        /* Responsividade para máquinas */
        @media (max-width: 1200px) {
            .machines-stats {
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
                gap: 0.75rem;
                padding: 1.5rem;
            }
            
            .stat-card {
                padding: 1rem;
            }
            
            .stat-number {
                font-size: 1.5rem;
            }
        }

        @media (max-width: 768px) {
            .main-content {
                padding: 1rem;
            }
            
            .page-title {
                font-size: 2rem;
            }
            
            .dashboard-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }
            
            .form-grid {
                grid-template-columns: 1fr;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-group {
                flex-direction: column;
            }

            .machines-header {
                padding: 1.5rem 1rem;
            }

            .machines-header h2 {
                font-size: 1.5rem;
                flex-direction: column;
                gap: 0.5rem;
            }

            .machines-header i {
                font-size: 1.5rem;
            }

            .machines-stats {
                grid-template-columns: repeat(2, 1fr);
                padding: 1rem;
                gap: 0.5rem;
            }

            .stat-card {
                padding: 0.75rem;
            }

            .stat-number {
                font-size: 1.25rem;
            }

            .stat-label {
                font-size: 0.75rem;
            }

            .machines-table th,
            .machines-table td {
                padding: 0.5rem 0.25rem;
                font-size: 0.75rem;
            }

            .machines-table .btn-group {
                flex-direction: column;
                gap: 0.25rem;
            }

            .machines-table .btn-group .btn {
                padding: 0.25rem 0.5rem;
                font-size: 0.7rem;
            }

            .machine-number {
                font-size: 0.9rem;
                padding: 0.25rem 0.5rem;
            }
        }

        @media (max-width: 480px) {
            .machines-stats {
                grid-template-columns: 1fr;
            }

            .machines-table th,
            .machines-table td {
                padding: 0.25rem;
                font-size: 0.7rem;
            }

            .badge {
                padding: 0.25rem 0.5rem;
                font-size: 0.7rem;
                min-width: 2rem;
            }
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <!-- Main Content -->
    <main class="main-content">

        <!-- Dashboard Grid -->
        <div class="dashboard-grid">
            <!-- Messages -->
            <?php if (isset($_GET['msg'])): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?php
                    $messages = [
                        'reiniciado' => 'Máquina reiniciada com sucesso!',
                        'reiniciado_bons' => 'Contas boas reiniciadas com sucesso!',
                        'removido_invalidas' => 'Contas inválidas removidas!',
                        'removido_bloqueadas' => 'Contas bloqueadas removidas!',
                        'maquina_removida' => 'Máquina removida com sucesso!',
                        'todos_reiniciados' => 'Todas as máquinas foram reiniciadas!',
                        'bons_reiniciados' => 'Todas as contas boas foram reiniciadas!',
                        'invalidas_removidas' => 'Todas as contas inválidas foram removidas!',
                        'todas_apagadas' => 'Todas as máquinas foram apagadas!'
                    ];
                    echo $messages[$_GET['msg']] ?? 'Operação realizada com sucesso!';
                    ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($success_message)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?= $success_message ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($upload_success)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?= $upload_success ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($upload_error)): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?= $upload_error ?>
                </div> 
            <?php endif; ?>

            <!-- Upload de Cookies Card -->
            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-upload"></i> Cadastrar Perfis em Massa</h2>
                </div>
                <div class="card-body">
                    <form method="POST" enctype="multipart/form-data">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="fileUpload">Arquivo (.txt com cookies)</label>
                                <input type="file" name="fileUpload" class="form-control" id="fileUpload" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="maquina">Código da Máquina</label>
                                <input type="number" name="maquina" class="form-control" id="maquina" required min="1">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label class="radio-label">
                                <input value="1" type="radio" name="option" checked>
                                Alterar somente a máquina selecionada
                            </label>
                            <label class="radio-label">
                                <input value="2" type="radio" name="option">
                                Alterar todas as máquinas
                            </label>
                        </div>
                        
                        <button type="submit" name="carregar" class="btn btn-primary">
                            <i class="fas fa-upload"></i> Carregar
                        </button>
                    </form>
                </div>
            </div>

            <!-- Configurações Card -->
            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-cog"></i> Configurações</h2>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="navegadores">Navegadores</label>
                                <input type="number" name="navegadores" class="form-control" id="navegadores" required min="1" placeholder="Quantos navegadores abrir?">
                            </div>
                            
                            <div class="form-group">
                                <label for="acoesnum">Ações por Navegador</label>
                                <input type="number" name="acoesnum" class="form-control" id="acoesnum" required min="1" placeholder="Ações por navegador">
                            </div>
                            
                            <div class="form-group">
                                <label for="rolagens">Rolagens</label>
                                <input type="number" name="rolagens" class="form-control" id="rolagens" required min="0" placeholder="Quantas rolagens?">
                            </div>
                            
                            <div class="form-group">
                                <label for="usuariofake">Usuário Fake</label>
                                <input type="text" name="usuariofake" class="form-control" id="usuariofake" required placeholder="Usuário para seguir clientes">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="maquinaid">Código da Máquina</label>
                            <input type="text" name="maquinaid" class="form-control" id="maquinaid" required placeholder="Use vírgula para múltiplas: 1,2,3">
                        </div>
                        
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save"></i> Salvar
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Máquinas e Ações -->
        <?php if ($maquinas_query && $maquinas_query->num_rows > 0): 
            // Calcular totais gerais de todas as máquinas ANTES de usar
            $total_geral = 0;
            $usadas_geral = 0;
            $restantes_geral = 0;
            $contassucesso_geral = 0;
            $contasbloqueadasporcookie_geral = 0;
            $contasbloqueadasporaction_geral = 0;
            $contasbloqueadaspor2fatores_geral = 0;
            $contaslimitemaximo_geral = 0;
            $contasmanyrequest_geral = 0;
            $contassolicitacao_geral = 0;
            
            // Resetar o ponteiro da query para calcular totais
            $maquinas_query->data_seek(0);
            
            while ($maquina_temp = $maquinas_query->fetch_assoc()): 
                $num_temp = $maquina_temp['maquinas'];
                $table_name_temp = "maquina_$num_temp";
                
                $stats_query_temp = $mysqli->query("
                    SELECT 
                        COUNT(*) as total,
                        SUM(CASE WHEN error != 0 THEN 1 ELSE 0 END) as usadas,
                        SUM(CASE WHEN error = 1 THEN 1 ELSE 0 END) as contassucesso,
                        SUM(CASE WHEN error = 3 THEN 1 ELSE 0 END) as contasbloqueadasporcookie,
                        SUM(CASE WHEN error = 4 THEN 1 ELSE 0 END) as contasbloqueadasporaction,
                        SUM(CASE WHEN error = 5 THEN 1 ELSE 0 END) as contasbloqueadaspor2fatores,
                        SUM(CASE WHEN error = 7 THEN 1 ELSE 0 END) as contaslimitemaximo,
                        SUM(CASE WHEN error = 8 THEN 1 ELSE 0 END) as contasmanyrequest,
                        SUM(CASE WHEN error = 9 THEN 1 ELSE 0 END) as contassolicitacao
                    FROM `$table_name_temp`
                ");
                
                if ($stats_query_temp) {
                    $stats_temp = $stats_query_temp->fetch_assoc();
                    $total_geral += $stats_temp['total'];
                    $usadas_geral += $stats_temp['usadas'];
                    $contassucesso_geral += $stats_temp['contassucesso'];
                    $contasbloqueadasporcookie_geral += $stats_temp['contasbloqueadasporcookie'];
                    $contasbloqueadasporaction_geral += $stats_temp['contasbloqueadasporaction'];
                    $contasbloqueadaspor2fatores_geral += $stats_temp['contasbloqueadaspor2fatores'];
                    $contaslimitemaximo_geral += $stats_temp['contaslimitemaximo'];
                    $contasmanyrequest_geral += $stats_temp['contasmanyrequest'];
                    $contassolicitacao_geral += $stats_temp['contassolicitacao'];
                }
            endwhile;
            
            $restantes_geral = $total_geral - $usadas_geral;
            
            // Resetar o ponteiro da query para o loop principal
            $maquinas_query->data_seek(0);
        ?>
        <div class="machines-container">
            <div class="machines-header">
                <h2><i class="fas fa-server"></i> Máquinas Cadastradas</h2>
            </div>
            
            <!-- Estatísticas Gerais -->
            <div class="machines-stats">
                <div class="stat-card">
                    <div class="stat-number stat-primary"><?= $total_geral ?></div>
                    <div class="stat-label">Total de Contas</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number stat-info"><?= $usadas_geral ?></div>
                    <div class="stat-label">Já Rodaram</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number stat-secondary"><?= $restantes_geral ?></div>
                    <div class="stat-label">Restantes</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number stat-success"><?= $contassucesso_geral ?></div>
                    <div class="stat-label">Sucessos</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number stat-warning"><?= $contasbloqueadasporcookie_geral ?></div>
                    <div class="stat-label">Cookies Inválidos</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number stat-danger"><?= $contasbloqueadasporaction_geral ?></div>
                    <div class="stat-label">Bloqueadas</div>
                </div>
            </div>
            
            <div class="table-container">
                <table class="machines-table">
                            <thead>
                                <tr>
                                    <th>Máquina</th>
                                    <th>Total Contas</th>
                                    <th>Já Rodou</th>
                                    <th>Restantes</th>
                                    <th>Sucesso</th>
                                    <th>Cookie Inválido</th>
                                    <th>Bloqueadas por Ação</th>
                                    <th>2FA</th>
                                    <th>Limite Máximo</th>
                                    <th>Many Requests</th>
                                    <th>Solicitação</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <!-- Linha de Total Geral -->
                                <tr class="total-row">
                                    <td><span class="machine-number">TOTAL</span></td>
                                    <td><span class="badge badge-primary"><?= $total_geral ?></span></td>
                                    <td><span class="badge badge-info"><?= $usadas_geral ?></span></td>
                                    <td><span class="badge badge-secondary"><?= $restantes_geral ?></span></td>
                                    <td><span class="badge badge-success"><?= $contassucesso_geral ?></span></td>
                                    <td><span class="badge badge-warning"><?= $contasbloqueadasporcookie_geral ?></span></td>
                                    <td><span class="badge badge-danger"><?= $contasbloqueadasporaction_geral ?></span></td>
                                    <td><span class="badge badge-warning"><?= $contasbloqueadaspor2fatores_geral ?></span></td>
                                    <td><span class="badge badge-orange"><?= $contaslimitemaximo_geral ?></span></td>
                                    <td><span class="badge badge-warning"><?= $contasmanyrequest_geral ?></span></td>
                                    <td><span class="badge badge-secondary"><?= $contassolicitacao_geral ?></span></td>
                                    <td>
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-secondary" style="background: #6c757d; color: white; cursor: default; border: none;" disabled>
                                                <i class="fas fa-calculator"></i>
                                                <span>TOTALIZADOR</span>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                
                                <?php while ($maquina = $maquinas_query->fetch_assoc()): 
                                    $num = $maquina['maquinas'];
                                    $table_name = "maquina_$num";
                                    
                                    // Consulta otimizada - uma única query para todas as estatísticas
                                    $stats_query = $mysqli->query("
                                        SELECT 
                                            COUNT(*) as total,
                                            SUM(CASE WHEN error != 0 THEN 1 ELSE 0 END) as usadas,
                                            SUM(CASE WHEN error = 1 THEN 1 ELSE 0 END) as contassucesso,
                                            SUM(CASE WHEN error = 3 THEN 1 ELSE 0 END) as contasbloqueadasporcookie,
                                            SUM(CASE WHEN error = 4 THEN 1 ELSE 0 END) as contasbloqueadasporaction,
                                            SUM(CASE WHEN error = 5 THEN 1 ELSE 0 END) as contasbloqueadaspor2fatores,
                                            SUM(CASE WHEN error = 7 THEN 1 ELSE 0 END) as contaslimitemaximo,
                                            SUM(CASE WHEN error = 8 THEN 1 ELSE 0 END) as contasmanyrequest,
                                            SUM(CASE WHEN error = 9 THEN 1 ELSE 0 END) as contassolicitacao
                                        FROM `$table_name`
                                    ");
                                    
                                    if ($stats_query) {
                                        $stats = $stats_query->fetch_assoc();
                                        $total = $stats['total'];
                                        $usadas = $stats['usadas'];
                                        $restantes = $total - $usadas;
                                        $contassucesso = $stats['contassucesso'];
                                        $contasbloqueadasporcookie = $stats['contasbloqueadasporcookie'];
                                        $contasbloqueadasporaction = $stats['contasbloqueadasporaction'];
                                        $contasbloqueadaspor2fatores = $stats['contasbloqueadaspor2fatores'];
                                        $contaslimitemaximo = $stats['contaslimitemaximo'];
                                        $contasmanyrequest = $stats['contasmanyrequest'];
                                        $contassolicitacao = $stats['contassolicitacao'];
                                    } else {
                                        // Valores padrão em caso de erro
                                        $total = $usadas = $restantes = 0;
                                        $contassucesso = $contasbloqueadasporcookie = $contasbloqueadasporaction = 0;
                                        $contasbloqueadaspor2fatores = $contaslimitemaximo = 0;
                                        $contasmanyrequest = $contassolicitacao = 0;
                                    }
                                ?>
                                <tr>
                                    <td><span class="machine-number"><?= $num ?></span></td>
                                    <td><span class="badge badge-primary"><?= $total ?></span></td>
                                    <td><span class="badge badge-info"><?= $usadas ?></span></td>
                                    <td><span class="badge badge-secondary"><?= $restantes ?></span></td>
                                    <td><span class="badge badge-success"><?= $contassucesso ?></span></td>
                                    <td><span class="badge badge-warning"><?= $contasbloqueadasporcookie ?></span></td>
                                    <td><span class="badge badge-danger"><?= $contasbloqueadasporaction ?></span></td>
                                    <td><span class="badge badge-warning"><?= $contasbloqueadaspor2fatores ?></span></td>
                                    <td><span class="badge badge-orange"><?= $contaslimitemaximo ?></span></td>
                                    <td><span class="badge badge-warning"><?= $contasmanyrequest ?></span></td>
                                    <td><span class="badge badge-secondary"><?= $contassolicitacao ?></span></td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="?acao=reiniciarbons&id=<?= $table_name ?>" class="btn btn-sm btn-machine-success" title="Reiniciar Contas Boas">
                                                <i class="fas fa-sync-alt"></i>
                                                <span>Bons</span>
                                            </a>
                                            <a href="?acao=reiniciar&id=<?= $table_name ?>" class="btn btn-sm btn-machine-info" title="Reiniciar Todas as Contas">
                                                <i class="fas fa-redo"></i>
                                                <span>Todos</span>
                                            </a>
                                            <a href="?acao=removerinvalidas&id=<?= $table_name ?>" class="btn btn-sm btn-machine-warning" title="Remover Contas Inválidas">
                                                <i class="fas fa-user-times"></i>
                                                <span>Inválidas</span>
                                            </a>
                                            <a href="?acao=removerbloqueadas&id=<?= $table_name ?>" class="btn btn-sm btn-machine-orange" title="Remover Contas Bloqueadas">
                                                <i class="fas fa-ban"></i>
                                                <span>Bloqueadas</span>
                                            </a>
                                            <a href="?acao=removermaquina&id=<?= $table_name ?>" class="btn btn-sm btn-machine-danger" onclick="return confirm('Remover máquina <?= $num ?>?')" title="Apagar Máquina">
                                                <i class="fas fa-trash"></i>
                                                <span>Apagar</span>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

        <!-- Ações em Massa -->
        <div class="card">
            <div class="card-header">
                <h2><i class="fas fa-tasks"></i> Ações em Massa</h2>
            </div>
            <div class="card-body">
                <div class="action-buttons">
                    <a href="?acao=reiniciarbonstodos" class="btn btn-success" onclick="return confirm('Reiniciar todas as contas boas?')">
                        <i class="fas fa-sync-alt"></i> Reiniciar Bons
                    </a>
                    <a href="?acao=reiniciartodos" class="btn btn-info" onclick="return confirm('Reiniciar TODAS as máquinas?')">
                        <i class="fas fa-redo"></i> Reiniciar Todas
                    </a>
                    <a href="?acao=removertodos" class="btn btn-warning" onclick="return confirm('Remover TODAS as contas inválidas?')">
                        <i class="fas fa-trash-alt"></i> Remover Inválidas
                    </a>
                    <a href="?acao=apagartodas" class="btn btn-danger" onclick="return confirm('ATENÇÃO! Apagar TODAS as máquinas? Esta ação não pode ser desfeita!')">
                        <i class="fas fa-times-circle"></i> Apagar Todas
                    </a>
                </div>
            </div>
        </div>
            <?php endif; ?>
    </main>
</body>
</html>