<!-- Navbar Unificado -->
<nav class="navbar">
    <div class="navbar-brand">
        <i class="fas fa-robot"></i>
        <span><?= APP_NAME ?></span>
    </div>
    
    <div class="navbar-menu">
        <div class="navbar-item">
            <a href="index" class="navbar-link <?= basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : '' ?>">
                <i class="fas fa-server"></i>
                <span>BOT</span>
            </a>
        </div>
        
        <div class="navbar-item">
            <a href="comentarios" class="navbar-link <?= basename($_SERVER['PHP_SELF']) == 'comentarios.php' ? 'active' : '' ?>">
                <i class="fas fa-history"></i>
                <span>Histórico</span>
            </a>
        </div>
        
        <div class="navbar-item">
            <a href="pendentes" class="navbar-link <?= basename($_SERVER['PHP_SELF']) == 'pendentes.php' ? 'active' : '' ?>">
                <i class="fas fa-clock"></i>
                <span>Pendentes</span>
            </a>
        </div>
        
        <div class="navbar-item">
            <a href="aprovados" class="navbar-link <?= basename($_SERVER['PHP_SELF']) == 'aprovados.php' ? 'active' : '' ?>">
                <i class="fas fa-check-circle"></i>
                <span>Aprovados</span>
            </a>
        </div>
        
        <div class="navbar-item">
            <a href="maquinas" class="navbar-link <?= basename($_SERVER['PHP_SELF']) == 'maquinas.php' ? 'active' : '' ?>">
                <i class="fas fa-desktop"></i>
                <span>Máquinas</span>
            </a>
        </div>
    </div>
    
    <div class="navbar-user">
        <div class="user-info">
            <i class="fas fa-user-circle"></i>
            <span><?= htmlspecialchars($_SESSION['user_email']) ?></span>
        </div>
        <?php if (isset($_SESSION['user_email']) && $_SESSION['user_email'] === $_ENV['ADMIN_EMAIL']): ?>
        <a href="admin_register" class="admin-btn" title="Cadastro de Usuários">
            <i class="fas fa-user-plus"></i>
            <span>Admin</span>
        </a>
        <?php endif; ?>
        <a href="logout" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i>
            <span>Sair</span>
        </a>
    </div>
    
    <!-- Mobile Menu Toggle -->
    <div class="navbar-toggle" onclick="toggleMobileMenu()">
        <i class="fas fa-bars"></i>
    </div>
</nav>

<!-- Include CSS files -->
<link rel="stylesheet" href="assets/css/base.css">
<link rel="stylesheet" href="assets/css/navbar.css">
<link rel="stylesheet" href="assets/css/main-content.css">

<style>
/* Navbar Styles */
.navbar {
    background: linear-gradient(135deg, var(--color-primary) 0%, var(--color-primary-dark) 100%);
    color: white;
    padding: 0 2rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    position: sticky;
    top: 0;
    z-index: 1000;
    min-height: 70px;
}

.navbar-brand {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    font-size: 1.5rem;
    font-weight: 700;
    color: white;
    text-decoration: none;
}

.navbar-brand i {
    font-size: 1.75rem;
}

.navbar-menu {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.navbar-item {
    position: relative;
}

.navbar-link {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1rem;
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
    border-radius: var(--border-radius-md);
    transition: all var(--transition-base);
    font-weight: 500;
    position: relative;
}

.navbar-link:hover {
    background: rgba(255, 255, 255, 0.1);
    color: white;
    transform: translateY(-1px);
}

.navbar-link.active {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    font-weight: 600;
}

.navbar-link.active::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 50%;
    transform: translateX(-50%);
    width: 80%;
    height: 2px;
    background: white;
    border-radius: 1px;
}

.navbar-link i {
    font-size: 1rem;
}

.navbar-user {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.user-info {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: rgba(255, 255, 255, 0.9);
    font-size: 0.9rem;
}

.user-info i {
    font-size: 1.25rem;
}

.logout-btn {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    background: rgba(255, 255, 255, 0.1);
    color: white;
    text-decoration: none;
    border-radius: var(--border-radius-md);
    transition: all var(--transition-base);
    font-size: 0.9rem;
}

.logout-btn:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
}

.navbar-toggle {
    display: none;
    color: white;
    font-size: 1.25rem;
    cursor: pointer;
    padding: 0.5rem;
}

/* Mobile Styles */
@media (max-width: 768px) {
    .navbar {
        padding: 0 1rem;
        flex-wrap: wrap;
        min-height: 60px;
    }
    
    .navbar-menu {
        display: none;
        width: 100%;
        flex-direction: column;
        background: var(--color-primary-dark);
        border-radius: var(--border-radius-md);
        padding: 1rem 0;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
    }
    
    .navbar-menu.active {
        display: flex;
    }
    
    .navbar-item {
        width: 100%;
    }
    
    .navbar-link {
        width: 100%;
        justify-content: flex-start;
        padding: 1rem 1.5rem;
        border-radius: 0;
    }
    
    .navbar-link:hover {
        background: rgba(255, 255, 255, 0.1);
    }
    
    .navbar-user {
        flex-direction: column;
        gap: 0.5rem;
        align-items: flex-end;
    }
    
    .user-info {
        font-size: 0.8rem;
    }
    
    .logout-btn {
        font-size: 0.8rem;
        padding: 0.4rem 0.8rem;
    }
    
    .navbar-toggle {
        display: block;
    }
}

@media (max-width: 480px) {
    .navbar-brand span {
        display: none;
    }
    
    .navbar-link span {
        display: none;
    }
    
    .logout-btn span {
        display: none;
    }
    
    .user-info span {
        display: none;
    }
}

/* Animation for mobile menu */
.navbar-menu {
    animation: slideDown 0.3s ease-out;
}

@keyframes slideDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Hover effects */
.navbar-link::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.1), transparent);
    opacity: 0;
    transition: opacity var(--transition-base);
    border-radius: var(--border-radius-md);
}

.navbar-link:hover::before {
    opacity: 1;
}

/* Active state enhancement */
.navbar-link.active {
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
}

/* Responsive adjustments */
@media (min-width: 769px) and (max-width: 1024px) {
    .navbar-link span {
        font-size: 0.9rem;
    }
    
    .navbar-brand {
        font-size: 1.3rem;
    }
}
</style>

<script>
function toggleMobileMenu() {
    const menu = document.querySelector('.navbar-menu');
    const toggle = document.querySelector('.navbar-toggle i');
    
    menu.classList.toggle('active');
    
    if (menu.classList.contains('active')) {
        toggle.classList.remove('fa-bars');
        toggle.classList.add('fa-times');
    } else {
        toggle.classList.remove('fa-times');
        toggle.classList.add('fa-bars');
    }
}

// Close mobile menu when clicking outside
document.addEventListener('click', function(event) {
    const navbar = document.querySelector('.navbar');
    const menu = document.querySelector('.navbar-menu');
    const toggle = document.querySelector('.navbar-toggle');
    
    if (!navbar.contains(event.target) && menu.classList.contains('active')) {
        menu.classList.remove('active');
        const toggleIcon = toggle.querySelector('i');
        toggleIcon.classList.remove('fa-times');
        toggleIcon.classList.add('fa-bars');
    }
});

// Close mobile menu when window is resized to desktop
window.addEventListener('resize', function() {
    const menu = document.querySelector('.navbar-menu');
    const toggle = document.querySelector('.navbar-toggle i');
    
    if (window.innerWidth > 768 && menu.classList.contains('active')) {
        menu.classList.remove('active');
        toggle.classList.remove('fa-times');
        toggle.classList.add('fa-bars');
    }
});
</script>
