<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Navbar Refatorado - Demo</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/navbar.css">
    <link rel="stylesheet" href="assets/css/main-content.css">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
            background: var(--color-background);
        }
        
        .demo-content {
            padding: 2rem;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .demo-section {
            background: var(--color-surface);
            border-radius: var(--border-radius-lg);
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: var(--shadow-md);
        }
        
        .demo-title {
            color: var(--color-primary);
            margin-bottom: 1rem;
            font-size: 1.5rem;
            font-weight: 600;
        }
        
        .demo-text {
            color: var(--color-text-secondary);
            line-height: 1.6;
            margin-bottom: 1rem;
        }
        
        .demo-features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-top: 1.5rem;
        }
        
        .demo-feature {
            background: var(--color-surface-variant);
            padding: 1rem;
            border-radius: var(--border-radius-md);
            border-left: 4px solid var(--color-primary);
        }
        
        .demo-feature h4 {
            color: var(--color-primary);
            margin-bottom: 0.5rem;
            font-size: 1rem;
        }
        
        .demo-feature p {
            color: var(--color-text-secondary);
            font-size: 0.9rem;
            margin: 0;
        }
        
        .demo-code {
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 1rem;
            border-radius: var(--border-radius-md);
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            overflow-x: auto;
            margin: 1rem 0;
        }
        
        .demo-code .comment {
            color: #6a9955;
        }
        
        .demo-code .keyword {
            color: #569cd6;
        }
        
        .demo-code .string {
            color: #ce9178;
        }
        
        .demo-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .demo-header h1 {
            color: var(--color-primary);
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        
        .demo-header p {
            color: var(--color-text-secondary);
            font-size: 1.1rem;
        }
        
        .demo-comparison {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin: 2rem 0;
        }
        
        .demo-before,
        .demo-after {
            padding: 1.5rem;
            border-radius: var(--border-radius-md);
            border: 2px solid var(--color-border);
        }
        
        .demo-before {
            background: #ffe6e6;
            border-color: #ff6b6b;
        }
        
        .demo-after {
            background: #e6ffe6;
            border-color: #51cf66;
        }
        
        .demo-before h3 {
            color: #ff6b6b;
            margin-bottom: 1rem;
        }
        
        .demo-after h3 {
            color: #51cf66;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <!-- Demo Content -->
    <main class="main-content">
        <div class="demo-content">
            <div class="demo-header">
                <h1>🚀 Navbar Refatorado</h1>
                <p>Navbar unificado sem header duplicado - Design limpo e moderno</p>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">✨ Melhorias Implementadas</h2>
                <p class="demo-text">
                    O navbar foi completamente refatorado para oferecer uma experiência mais limpa e integrada.
                </p>
                
                <div class="demo-comparison">
                    <div class="demo-before">
                        <h3>❌ Antes</h3>
                        <ul>
                            <li>Header duplicado</li>
                            <li>Informações redundantes</li>
                            <li>Espaçamento inconsistente</li>
                            <li>Design fragmentado</li>
                        </ul>
                    </div>
                    
                    <div class="demo-after">
                        <h3>✅ Depois</h3>
                        <ul>
                            <li>Navbar unificado</li>
                            <li>Informações consolidadas</li>
                            <li>Espaçamento otimizado</li>
                            <li>Design integrado</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🎨 Características do Design</h2>
                <p class="demo-text">
                    O novo navbar combina funcionalidade e estética em um design moderno e responsivo.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-unify"></i> Unificado</h4>
                        <p>Brand, navegação e usuário em um só lugar</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile-alt"></i> Responsivo</h4>
                        <p>Menu hambúrguer para dispositivos móveis</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-palette"></i> Moderno</h4>
                        <p>Gradientes, sombras e animações suaves</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-eye"></i> Intuitivo</h4>
                        <p>Indicadores visuais claros da página ativa</p>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🔧 Estrutura do Navbar</h2>
                <p class="demo-text">
                    O navbar é composto por três seções principais que trabalham em harmonia.
                </p>
                
                <div class="demo-code">
<span class="comment">&lt;!-- Estrutura do navbar --&gt;</span>
<span class="keyword">&lt;nav</span> <span class="string">class</span>=<span class="string">"navbar"</span><span class="keyword">&gt;</span>
    <span class="comment">&lt;!-- Brand/Logo --&gt;</span>
    <span class="keyword">&lt;div</span> <span class="string">class</span>=<span class="string">"navbar-brand"</span><span class="keyword">&gt;</span>
        <span class="keyword">&lt;i</span> <span class="string">class</span>=<span class="string">"fas fa-robot"</span><span class="keyword">&gt;&lt;/i</span><span class="keyword">&gt;</span>
        <span class="keyword">&lt;span</span><span class="keyword">&gt;</span><?= APP_NAME ?><span class="keyword">&lt;/span</span><span class="keyword">&gt;</span>
    <span class="keyword">&lt;/div</span><span class="keyword">&gt;</span>
    
    <span class="comment">&lt;!-- Menu de Navegação --&gt;</span>
    <span class="keyword">&lt;div</span> <span class="string">class</span>=<span class="string">"navbar-menu"</span><span class="keyword">&gt;</span>
        <span class="comment">&lt;!-- Links de navegação --&gt;</span>
    <span class="keyword">&lt;/div</span><span class="keyword">&gt;</span>
    
    <span class="comment">&lt;!-- Informações do Usuário --&gt;</span>
    <span class="keyword">&lt;div</span> <span class="string">class</span>=<span class="string">"navbar-user"</span><span class="keyword">&gt;</span>
        <span class="comment">&lt;!-- Email e botão de logout --&gt;</span>
    <span class="keyword">&lt;/div</span><span class="keyword">&gt;</span>
<span class="keyword">&lt;/nav</span><span class="keyword">&gt;</span>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">📱 Responsividade</h2>
                <p class="demo-text">
                    O navbar se adapta automaticamente a diferentes tamanhos de tela, oferecendo a melhor experiência em cada dispositivo.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-desktop"></i> Desktop (>768px)</h4>
                        <p>Menu horizontal com todos os elementos visíveis</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-tablet-alt"></i> Tablet (768px)</h4>
                        <p>Menu compacto com texto reduzido</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile-alt"></i> Mobile (<768px)</h4>
                        <p>Menu hambúrguer expansível</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-mobile"></i> Mobile Pequeno (<480px)</h4>
                        <p>Apenas ícones visíveis</p>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🎯 Benefícios</h2>
                <p class="demo-text">
                    A refatoração do navbar trouxe diversos benefícios para o sistema.
                </p>
                
                <div class="demo-features">
                    <div class="demo-feature">
                        <h4><i class="fas fa-rocket"></i> Performance</h4>
                        <p>Menos elementos DOM e CSS otimizado</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-paint-brush"></i> Design</h4>
                        <p>Interface mais limpa e profissional</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-cogs"></i> Manutenção</h4>
                        <p>Código mais organizado e fácil de manter</p>
                    </div>
                    
                    <div class="demo-feature">
                        <h4><i class="fas fa-users"></i> UX</h4>
                        <p>Experiência do usuário mais fluida</p>
                    </div>
                </div>
            </div>
            
            <div class="demo-section">
                <h2 class="demo-title">🔧 Como Usar</h2>
                <p class="demo-text">
                    Para usar o navbar refatorado em suas páginas, simplesmente inclua o arquivo <code>navbar.php</code>:
                </p>
                
                <div class="demo-code">
<span class="comment">&lt;!-- Incluir navbar em qualquer página --&gt;</span>
<span class="keyword">&lt;?php</span> <span class="string">include</span> <span class="string">'navbar.php'</span>; <span class="keyword">?&gt;</span>

<span class="comment">&lt;!-- O navbar detecta automaticamente a página atual --&gt;</span>
<span class="comment">&lt;!-- e marca o link correspondente como ativo --&gt;</span>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <p>&copy; <?= date('Y') ?> <?= APP_NAME ?> - Navbar Refatorado Demo</p>
    </footer>
</body>
</html>
