-- Schema do Banco de Dados para Sistema de Moderação
-- Laragon MySQL

CREATE DATABASE IF NOT EXISTS moderacao CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE moderacao;

-- Tabela de comentários e resultados de moderação
CREATE TABLE IF NOT EXISTS comments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    content TEXT NOT NULL,
    flagged BOOLEAN DEFAULT FALSE,
    moderation_id VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_flagged (flagged),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de categorias de moderação
CREATE TABLE IF NOT EXISTS moderation_categories (
    id INT AUTO_INCREMENT PRIMARY KEY,
    comment_id INT NOT NULL,
    category_name VARCHAR(100) NOT NULL,
    category_detected BOOLEAN DEFAULT FALSE,
    category_score DECIMAL(5,4) DEFAULT 0.0000,
    FOREIGN KEY (comment_id) REFERENCES comments(id) ON DELETE CASCADE,
    INDEX idx_comment_id (comment_id),
    INDEX idx_category_name (category_name),
    INDEX idx_detected (category_detected)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de feedback de treinamento
CREATE TABLE IF NOT EXISTS feedback (
    id INT AUTO_INCREMENT PRIMARY KEY,
    comment_id INT NOT NULL,
    is_correct BOOLEAN NOT NULL COMMENT 'TRUE se a moderação estava correta, FALSE se estava incorreta',
    user_judgment ENUM('good', 'bad') NOT NULL COMMENT 'Julgamento do usuário: bom ou ruim',
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (comment_id) REFERENCES comments(id) ON DELETE CASCADE,
    INDEX idx_comment_id (comment_id),
    INDEX idx_is_correct (is_correct),
    INDEX idx_user_judgment (user_judgment)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de histórico completo de moderações
CREATE TABLE IF NOT EXISTS moderation_history (
    id INT AUTO_INCREMENT PRIMARY KEY,
    comment_id INT NOT NULL,
    moderation_response TEXT COMMENT 'JSON completo da resposta da API',
    api_model VARCHAR(100),
    api_id VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (comment_id) REFERENCES comments(id) ON DELETE CASCADE,
    INDEX idx_comment_id (comment_id),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de estatísticas (cache para performance)
CREATE TABLE IF NOT EXISTS moderation_stats (
    id INT AUTO_INCREMENT PRIMARY KEY,
    stat_date DATE NOT NULL,
    total_comments INT DEFAULT 0,
    flagged_comments INT DEFAULT 0,
    false_positives INT DEFAULT 0,
    false_negatives INT DEFAULT 0,
    category_counts TEXT COMMENT 'JSON com contagem por categoria',
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY unique_date (stat_date),
    INDEX idx_stat_date (stat_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

