<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuração da IA - Sistema de Comentários</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 20px; 
            background-color: #f5f5f5;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 { color: #333; text-align: center; }
        h2 { color: #555; border-bottom: 2px solid #007bff; padding-bottom: 5px; }
        .form-group { margin: 15px 0; }
        label { display: block; margin-bottom: 5px; font-weight: bold; color: #333; }
        input[type="number"], input[type="text"], textarea { 
            width: 100%; 
            padding: 8px; 
            border: 1px solid #ddd; 
            border-radius: 4px; 
            font-size: 14px;
        }
        input[type="number"] { max-width: 100px; }
        textarea { height: 100px; resize: vertical; }
        .threshold-group {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        .threshold-item {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            border: 1px solid #e9ecef;
        }
        .words-group {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin: 20px 0;
        }
        .words-section {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            border: 1px solid #e9ecef;
        }
        .words-section h3 {
            margin-top: 0;
            color: #007bff;
        }
        .timeout-group {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        .btn {
            background: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin: 10px 5px;
        }
        .btn:hover { background: #0056b3; }
        .btn-success { background: #28a745; }
        .btn-success:hover { background: #1e7e34; }
        .btn-warning { background: #ffc107; color: #212529; }
        .btn-warning:hover { background: #e0a800; }
        .alert {
            padding: 15px;
            margin: 15px 0;
            border-radius: 5px;
            border: 1px solid transparent;
        }
        .alert-success {
            background-color: #d4edda;
            border-color: #c3e6cb;
            color: #155724;
        }
        .alert-danger {
            background-color: #f8d7da;
            border-color: #f5c6cb;
            color: #721c24;
        }
        .help-text {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        .test-section {
            background: #e7f3ff;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            border: 1px solid #b3d9ff;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🤖 Configuração da IA - Sistema de Comentários</h1>
        
        <?php
        require_once 'config_ia.php';
        
        // Processar salvamento
        if ($_POST['action'] === 'save') {
            $thresholds = [];
            foreach ($_POST['thresholds'] as $key => $value) {
                $thresholds[$key] = floatval($value);
            }
            
            $negativeWords = array_filter(array_map('trim', explode(',', $_POST['negative_words'])));
            $positiveWords = array_filter(array_map('trim', explode(',', $_POST['positive_words'])));
            
            $timeouts = [];
            foreach ($_POST['timeouts'] as $key => $value) {
                $timeouts[$key] = intval($value);
            }
            
            if (saveConfig($thresholds, $negativeWords, $positiveWords, $timeouts)) {
                echo '<div class="alert alert-success">✅ Configuração salva com sucesso!</div>';
                // Recarregar configuração
                require_once 'config_ia.php';
            } else {
                echo '<div class="alert alert-danger">❌ Erro ao salvar configuração!</div>';
            }
        }
        
        // Carregar configuração atual
        $config = loadCurrentConfig();
        ?>
        
        <form method="POST">
            <input type="hidden" name="action" value="save">
            
            <h2>📊 Thresholds da IA</h2>
            <p class="help-text">Valores entre 0.0 e 1.0. Valores menores = mais sensível (detecta mais problemas)</p>
            
            <div class="threshold-group">
                <?php foreach ($config['thresholds'] as $key => $value): ?>
                <div class="threshold-item">
                    <label for="threshold_<?php echo $key; ?>"><?php echo $ATTR_PT[$key] ?? $key; ?></label>
                    <input type="number" 
                           id="threshold_<?php echo $key; ?>" 
                           name="thresholds[<?php echo $key; ?>]" 
                           value="<?php echo $value; ?>" 
                           min="0" 
                           max="1" 
                           step="0.01">
                    <div class="help-text"><?php echo $key; ?></div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <h2>📝 Palavras-Chave para Análise</h2>
            <p class="help-text">Usadas quando a API da IA falha. Separe por vírgulas.</p>
            
            <div class="words-group">
                <div class="words-section">
                    <h3>🔴 Palavras Negativas</h3>
                    <textarea name="negative_words" placeholder="ruim, péssimo, horrível, merda, problema..."><?php echo implode(', ', $config['negative_words']); ?></textarea>
                    <div class="help-text">Palavras que indicam comentários negativos</div>
                </div>
                
                <div class="words-section">
                    <h3>🟢 Palavras Positivas</h3>
                    <textarea name="positive_words" placeholder="bom, ótimo, excelente, recomendo, qualidade..."><?php echo implode(', ', $config['positive_words']); ?></textarea>
                    <div class="help-text">Palavras que indicam comentários positivos</div>
                </div>
            </div>
            
            <h2>⏱️ Configurações de Timeout</h2>
            <p class="help-text">Tempos em segundos para requisições da API</p>
            
            <div class="timeout-group">
                <div class="threshold-item">
                    <label for="timeout_main">Timeout Principal</label>
                    <input type="number" id="timeout_main" name="timeouts[main_timeout]" value="<?php echo $config['timeouts']['main_timeout']; ?>" min="1" max="10">
                    <div class="help-text">Tempo limite para análise principal</div>
                </div>
                
                <div class="threshold-item">
                    <label for="timeout_connect">Timeout Conexão</label>
                    <input type="number" id="timeout_connect" name="timeouts[connect_timeout]" value="<?php echo $config['timeouts']['connect_timeout']; ?>" min="1" max="5">
                    <div class="help-text">Tempo limite para conectar</div>
                </div>
                
                <div class="threshold-item">
                    <label for="timeout_fallback">Timeout Fallback</label>
                    <input type="number" id="timeout_fallback" name="timeouts[fallback_timeout]" value="<?php echo $config['timeouts']['fallback_timeout']; ?>" min="1" max="5">
                    <div class="help-text">Tempo limite para análise de fallback</div>
                </div>
                
                <div class="threshold-item">
                    <label for="timeout_fallback_connect">Timeout Fallback Conexão</label>
                    <input type="number" id="timeout_fallback_connect" name="timeouts[fallback_connect_timeout]" value="<?php echo $config['timeouts']['fallback_connect_timeout']; ?>" min="1" max="5">
                    <div class="help-text">Tempo limite para conectar no fallback</div>
                </div>
            </div>
            
            <div class="test-section">
                <h3>🧪 Teste Rápido</h3>
                <p>Teste as configurações com alguns comentários:</p>
                <button type="button" class="btn btn-warning" onclick="testConfig()">Testar Configuração</button>
                <div id="test-results"></div>
            </div>
            
            <div style="text-align: center; margin-top: 30px;">
                <button type="submit" class="btn btn-success">💾 Salvar Configuração</button>
                <button type="button" class="btn" onclick="resetToDefault()">🔄 Resetar para Padrão</button>
            </div>
        </form>
    </div>

    <script>
        function testConfig() {
            const testComments = [
                "Este produto é excelente!",
                "Que merda de produto",
                "Muito bom, recomendo",
                "Péssimo atendimento"
            ];
            
            document.getElementById('test-results').innerHTML = '<p>Testando...</p>';
            
            fetch('ia_analyze.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ comments: testComments })
            })
            .then(response => response.json())
            .then(data => {
                let html = '<h4>Resultados do Teste:</h4><table border="1" style="border-collapse: collapse; width: 100%;">';
                html += '<tr><th>Comentário</th><th>Resultado</th><th>Cor</th></tr>';
                
                data.results.forEach((result, i) => {
                    html += `<tr>
                        <td>${testComments[i]}</td>
                        <td>${result.label}</td>
                        <td style="background-color: ${result.color}; color: white;">${result.color}</td>
                    </tr>`;
                });
                
                html += '</table>';
                document.getElementById('test-results').innerHTML = html;
            })
            .catch(error => {
                document.getElementById('test-results').innerHTML = '<p style="color: red;">Erro no teste: ' + error.message + '</p>';
            });
        }
        
        function resetToDefault() {
            if (confirm('Deseja resetar todas as configurações para os valores padrão?')) {
                // Resetar thresholds
                document.querySelectorAll('input[name^="thresholds"]').forEach(input => {
                    input.value = '0.05';
                });
                
                // Resetar palavras-chave
                document.querySelector('textarea[name="negative_words"]').value = 'ruim, péssimo, horrível, terrível, merda, porcaria, lixo, fraco, decepcionado, insatisfeito, não recomendo, evitar, problema, defeito, quebrado, danificado, atraso, demora';
                document.querySelector('textarea[name="positive_words"]').value = 'bom, ótimo, excelente, fantástico, maravilhoso, perfeito, recomendo, satisfeito, qualidade, superou, vale a pena, funciona, rápido, eficiente, prático';
                
                // Resetar timeouts
                document.querySelector('input[name="timeouts[main_timeout]"]').value = '3';
                document.querySelector('input[name="timeouts[connect_timeout]"]').value = '2';
                document.querySelector('input[name="timeouts[fallback_timeout]"]').value = '2';
                document.querySelector('input[name="timeouts[fallback_connect_timeout]"]').value = '2';
            }
        }
    </script>
</body>
</html>
