<?php
require_once 'config.php';

// Verificar se foi enviado um order_id via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['order_id']) && !empty($_POST['order_id'])) {
    $order_id = (int)$_POST['order_id'];
    
    // Preparar a consulta SQL para atualizar todos os registros com o mesmo order_id
    $sql = "UPDATE history SET status = 'Completo' WHERE orderid = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $order_id);
    
    // Executar a consulta
    if ($stmt->execute()) {
        // Redirecionar de volta para a página de listagem com a pesquisa aplicada
        header("Location: index.php?search=" . urlencode($order_id) . "&success=1");
        exit;
    } else {
        // Em caso de erro, redirecionar com mensagem de erro
        header("Location: index.php?search=" . urlencode($order_id) . "&error=1");
        exit;
    }
} else {
    // Se não foi fornecido um order_id válido, redirecionar para a página inicial
    header("Location: index.php");
    exit;
}
?> 