<?php
/**
 * Script de Teste - Verifica se thresholds estão sendo aplicados na moderação
 */

header('Content-Type: text/html; charset=utf-8');

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/openai.php';
require_once __DIR__ . '/../config/thresholds.php';

echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Teste Moderação</title>";
echo "<style>body{font-family:Arial;padding:20px;} .section{margin:20px 0;padding:15px;border:1px solid #ddd;} .success{color:green;} .error{color:red;} .warning{color:orange;} table{border-collapse:collapse;width:100%;margin:10px 0;} th,td{border:1px solid #ddd;padding:8px;text-align:left;} th{background-color:#4CAF50;color:white;}</style>";
echo "</head><body>";
echo "<h1>Teste de Moderação com Thresholds</h1>";

try {
    // Carregar thresholds
    $thresholds = new ModerationThresholds();
    $loadedThresholds = $thresholds->loadThresholds();
    
    echo "<div class='section'>";
    echo "<h2>1. Thresholds Configurados:</h2>";
    if (empty($loadedThresholds)) {
        echo "<p class='error'>Nenhum threshold configurado!</p>";
    } else {
        echo "<table><tr><th>Categoria</th><th>Threshold</th></tr>";
        foreach ($loadedThresholds as $cat => $val) {
            echo "<tr><td>$cat</td><td>" . ($val * 100) . "%</td></tr>";
        }
        echo "</table>";
    }
    echo "</div>";
    
    // Simular chamada à API
    echo "<div class='section'>";
    echo "<h2>2. Simulando Moderação do Comentário 'arrombado':</h2>";
    
    // Simular resposta da API (valores reais do seu caso)
    $apiResponse = [
        'id' => 'modr-test-123',
        'results' => [
            [
                'categories' => [
                    'violence' => false,
                    'illicit' => false,
                    'sexual' => false,
                    'harassment' => false
                ],
                'category_scores' => [
                    'violence' => 0.0710,  // 7.10%
                    'illicit' => 0.0392,   // 3.92%
                    'sexual' => 0.0196,    // 1.96%
                    'harassment' => 0.0005 // 0.05%
                ],
                'flagged' => false
            ]
        ]
    ];
    
    echo "<h3>Resposta Original da API:</h3>";
    echo "<pre>" . json_encode($apiResponse, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    
    // Aplicar thresholds
    $responseWithThresholds = $thresholds->applyThresholds($apiResponse);
    
    echo "<h3>Resposta Após Aplicar Thresholds:</h3>";
    echo "<pre>" . json_encode($responseWithThresholds, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    
    $result = $responseWithThresholds['results'][0];
    
    echo "<h3>Análise Detalhada:</h3>";
    echo "<table><tr><th>Categoria</th><th>Score API</th><th>Threshold</th><th>Detectado?</th><th>Flagged?</th></tr>";
    
    foreach ($apiResponse['results'][0]['category_scores'] as $cat => $score) {
        $scorePercent = $score * 100;
        $threshold = isset($loadedThresholds[$cat]) ? $loadedThresholds[$cat] : null;
        $thresholdPercent = $threshold ? ($threshold * 100) : 'N/A';
        $detected = isset($result['categories'][$cat]) ? $result['categories'][$cat] : false;
        $detectedText = $detected ? 'SIM' : 'NÃO';
        $color = $detected ? 'red' : 'green';
        
        echo "<tr>";
        echo "<td><strong>$cat</strong></td>";
        echo "<td>$scorePercent%</td>";
        echo "<td>$thresholdPercent</td>";
        echo "<td style='color:$color;font-weight:bold'>$detectedText</td>";
        echo "<td>" . ($result['flagged'] ? 'SIM' : 'NÃO') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<p><strong>Resultado Final:</strong> ";
    if ($result['flagged']) {
        echo "<span class='error'>COMENTÁRIO SINALIZADO</span>";
    } else {
        echo "<span class='success'>Comentário Aprovado</span>";
    }
    echo "</p>";
    
    echo "</div>";
    
    // Teste real (se tiver chave configurada)
    echo "<div class='section'>";
    echo "<h2>3. Teste Real com Comentário Ofensivo:</h2>";
    
    $testComment = "Arrombado, filho da puta, te odeio, vou te matar, vai se fuder";
    
    if (defined('OPENAI_API_KEY') && !empty(OPENAI_API_KEY)) {
        try {
            $openai = new OpenAIModeration();
            echo "<p><strong>Comentário de teste:</strong> " . htmlspecialchars($testComment) . "</p>";
            
            $realResponse = $openai->moderate($testComment);
            
            echo "<h3>Resposta Original da API:</h3>";
            echo "<pre>" . json_encode($realResponse, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            
            // Aplicar thresholds
            $realWithThresholds = $thresholds->applyThresholds($realResponse);
            $realResult = $realWithThresholds['results'][0];
            
            echo "<h3>Após Aplicar Thresholds:</h3>";
            echo "<pre>" . json_encode($realWithThresholds, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            
            echo "<h3>Análise Detalhada do Comentário Real:</h3>";
            echo "<table><tr><th>Categoria</th><th>Score API</th><th>Threshold</th><th>Detectado?</th></tr>";
            
            foreach ($realResponse['results'][0]['category_scores'] as $cat => $score) {
                $scorePercent = $score * 100;
                $threshold = isset($loadedThresholds[$cat]) ? $loadedThresholds[$cat] : null;
                $thresholdPercent = $threshold ? ($threshold * 100) . '%' : 'N/A';
                $detected = isset($realResult['categories'][$cat]) ? $realResult['categories'][$cat] : false;
                $detectedText = $detected ? 'SIM ✓' : 'NÃO';
                $color = $detected ? 'red' : 'green';
                
                echo "<tr>";
                echo "<td><strong>$cat</strong></td>";
                echo "<td>$scorePercent%</td>";
                echo "<td>$thresholdPercent</td>";
                echo "<td style='color:$color;font-weight:bold'>$detectedText</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            echo "<p><strong>Resultado Final:</strong> ";
            if ($realResult['flagged']) {
                echo "<span class='error' style='font-size:20px;font-weight:bold'>✓ COMENTÁRIO SINALIZADO</span>";
            } else {
                echo "<span class='success' style='font-size:20px;font-weight:bold'>✗ Comentário Aprovado (PROBLEMA!)</span>";
            }
            echo "</p>";
            
        } catch (Exception $e) {
            echo "<p class='error'>Erro ao testar API real: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
    } else {
        echo "<p class='warning'>API não configurada. Configure OPENAI_API_KEY para testar.</p>";
    }
    
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div class='section'><p class='error'>Erro: " . htmlspecialchars($e->getMessage()) . "</p></div>";
}

echo "</body></html>";

