<?php
/**
 * API para Gerenciar Thresholds
 * Permite listar, criar e atualizar thresholds customizados
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/thresholds.php';

try {
    $method = $_SERVER['REQUEST_METHOD'];
    $thresholds = new ModerationThresholds();

    switch ($method) {
        case 'GET':
            // Listar todos os thresholds
            $allThresholds = $thresholds->getAllThresholds();
            echo json_encode([
                'success' => true,
                'thresholds' => $allThresholds
            ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            break;

        case 'POST':
        case 'PUT':
            // Criar ou atualizar threshold
            $input = file_get_contents('php://input');
            $data = json_decode($input, true);

            if (!$data) {
                $data = $_POST;
            }

            // Validar campos obrigatórios
            if (empty($data['category'])) {
                throw new Exception('Campo "category" é obrigatório');
            }

            if (!isset($data['threshold'])) {
                throw new Exception('Campo "threshold" é obrigatório');
            }

            $category = $data['category'];
            $threshold = floatval($data['threshold']);
            $enabled = isset($data['enabled']) ? (bool)$data['enabled'] : true;
            $description = $data['description'] ?? null;

            // Validar threshold (0.0 a 1.0)
            if ($threshold < 0.0 || $threshold > 1.0) {
                throw new Exception('Threshold deve estar entre 0.0 e 1.0');
            }

            $result = $thresholds->saveThreshold($category, $threshold, $enabled, $description);

            if ($result) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Threshold salvo com sucesso',
                    'category' => $category,
                    'threshold' => $threshold
                ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            } else {
                throw new Exception('Erro ao salvar threshold');
            }
            break;

        default:
            throw new Exception('Método não permitido');
    }

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}

