<?php
/**
 * Configuração do Banco de Dados
 * Usa as mesmas credenciais do config.php principal
 */

// Incluir configuração principal se disponível
$configPath = __DIR__ . '/../../../config.php';
if (file_exists($configPath)) {
    require_once $configPath;
    // Usar as constantes já definidas no config.php
} else {
    // Fallback: usar as mesmas credenciais do config.php
    define('DB_HOST', '147.93.5.135');
    define('DB_USER', 'su_aco');
    define('DB_PASS', 'PR,~F!Z72*A4=JG(');
    define('DB_NAME', 'su_co');
}

class Database {
    private static $instance = null;
    private $conn;

    private function __construct() {
        try {
            // Conectar diretamente ao banco (não criar, apenas conectar)
            $this->conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
            
            if ($this->conn->connect_error) {
                throw new Exception("Erro de conexão: " . $this->conn->connect_error);
            }
            
            // Definir charset
            $this->conn->set_charset("utf8mb4");
            
        } catch (Exception $e) {
            die("Erro ao conectar ao banco de dados: " . $e->getMessage());
        }
    }

    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function getConnection() {
        return $this->conn;
    }

    public function query($sql) {
        return $this->conn->query($sql);
    }

    public function prepare($sql) {
        return $this->conn->prepare($sql);
    }

    public function escape($string) {
        return $this->conn->real_escape_string($string);
    }

    public function getLastInsertId() {
        return $this->conn->insert_id;
    }
}

