<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Moderação de Comentários - OpenAI</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="bi bi-shield-check"></i> Moderação OpenAI
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="index.php">
                            <i class="bi bi-plus-circle"></i> Moderar
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php">
                            <i class="bi bi-graph-up"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="trainer.php">
                            <i class="bi bi-gear"></i> Treinamento
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="thresholds.php">
                            <i class="bi bi-sliders"></i> Thresholds
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0">
                            <i class="bi bi-chat-text"></i> Moderar Comentário
                        </h4>
                    </div>
                    <div class="card-body">
                        <form id="moderationForm">
                            <div class="mb-3">
                                <label for="commentInput" class="form-label">Comentário para Moderar</label>
                                <textarea 
                                    class="form-control" 
                                    id="commentInput" 
                                    rows="5" 
                                    placeholder="Digite o comentário que deseja moderar..."
                                    required
                                ></textarea>
                                <div class="form-text">
                                    Você pode moderar um comentário único ou múltiplos comentários (um por linha)
                                </div>
                                <div class="alert alert-info mt-2">
                                    <small><i class="bi bi-info-circle"></i> <strong>Nota:</strong> A API tem limites de taxa. Aguarde alguns segundos entre requisições para evitar erros.</small>
                                </div>
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="multipleInputs">
                                <label class="form-check-label" for="multipleInputs">
                                    Moderação em lote (um comentário por linha)
                                </label>
                            </div>

                            <button type="submit" class="btn btn-primary w-100" id="submitBtn">
                                <i class="bi bi-shield-check"></i> Moderar Comentário
                            </button>
                        </form>

                        <div id="loading" class="text-center mt-4" style="display: none;">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">Carregando...</span>
                            </div>
                            <p class="mt-2">Processando moderação...</p>
                        </div>

                        <div id="results" class="mt-4" style="display: none;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/app.js"></script>
</body>
</html>

