<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Treinamento - Sistema de Moderação</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="bi bi-shield-check"></i> Moderação OpenAI
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">
                            <i class="bi bi-plus-circle"></i> Moderar
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php">
                            <i class="bi bi-graph-up"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="trainer.php">
                            <i class="bi bi-gear"></i> Treinamento
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="thresholds.php">
                            <i class="bi bi-sliders"></i> Thresholds
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row mb-4">
            <div class="col-12">
                <h2><i class="bi bi-gear"></i> Ajustador de Treinamento</h2>
                <p class="text-muted">Revise e ajuste comentários para melhorar a precisão da moderação</p>
            </div>
        </div>

        <!-- Filtros -->
        <div class="row mb-4">
            <div class="col-md-3">
                <label for="filterFlagged" class="form-label">Status</label>
                <select class="form-select" id="filterFlagged">
                    <option value="">Todos</option>
                    <option value="1">Sinalizados</option>
                    <option value="0">Aprovados</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="filterCategory" class="form-label">Categoria</label>
                <select class="form-select" id="filterCategory">
                    <option value="">Todas</option>
                    <option value="hate">Ódio</option>
                    <option value="harassment">Assédio</option>
                    <option value="sexual">Sexual</option>
                    <option value="violence">Violência</option>
                    <option value="self-harm">Autolesão</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="filterDate" class="form-label">Data</label>
                <input type="date" class="form-control" id="filterDate">
            </div>
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <button class="btn btn-primary w-100" onclick="filterComments()">
                    <i class="bi bi-search"></i> Filtrar
                </button>
            </div>
        </div>

        <!-- Estatísticas de Precisão -->
        <div class="row mb-4" id="accuracyStats"></div>

        <!-- Lista de Comentários -->
        <div class="row">
            <div class="col-12">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-list-ul"></i> Comentários para Revisão</h5>
                    </div>
                    <div class="card-body">
                        <div id="commentsList">
                            <div class="text-center py-5">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Carregando...</span>
                                </div>
                                <p class="mt-2">Carregando comentários...</p>
                            </div>
                        </div>
                        <div id="pagination" class="mt-3 text-center"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal para Feedback -->
    <div class="modal fade" id="feedbackModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Fornecer Feedback</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Comentário:</label>
                        <div class="alert alert-light" id="modalCommentText"></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Resultado da Moderação:</label>
                        <div id="modalModerationResult"></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Seu Julgamento:</label>
                        <div class="btn-group w-100" role="group">
                            <input type="radio" class="btn-check" name="userJudgment" id="judgmentGood" value="good" checked>
                            <label class="btn btn-outline-success" for="judgmentGood">
                                <i class="bi bi-check-circle"></i> Bom
                            </label>
                            <input type="radio" class="btn-check" name="userJudgment" id="judgmentBad" value="bad">
                            <label class="btn btn-outline-danger" for="judgmentBad">
                                <i class="bi bi-x-circle"></i> Ruim
                            </label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="feedbackNotes" class="form-label">Observações (opcional)</label>
                        <textarea class="form-control" id="feedbackNotes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" onclick="submitFeedback()">
                        <i class="bi bi-save"></i> Salvar Feedback
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/trainer.js"></script>
</body>
</html>

