<?php
require_once 'config_ia.php';

// Limpar qualquer output anterior
ob_clean();

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, must-revalidate');

// Verificar se é uma requisição POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Método não permitido']);
    exit;
}

// Ler dados JSON
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!$data) {
    echo json_encode(['success' => false, 'error' => 'Dados inválidos']);
    exit;
}

try {
    // Validar dados
    $thresholds = $data['thresholds'] ?? [];
    $negativeWords = $data['negative_words'] ?? [];
    $positiveWords = $data['positive_words'] ?? [];
    $timeouts = $data['timeouts'] ?? [];
    
    // Validar thresholds
    foreach ($thresholds as $key => $value) {
        if (!is_numeric($value) || $value < 0 || $value > 1) {
            throw new Exception("Threshold inválido para $key: $value");
        }
    }
    
    // Validar timeouts
    foreach ($timeouts as $key => $value) {
        if (!is_numeric($value) || $value < 1 || $value > 300) {
            throw new Exception("Timeout inválido para $key: $value");
        }
    }
    
    // Preparar dados para salvar
    $config_data = [
        'thresholds' => $thresholds,
        'negative_words' => $negativeWords,
        'positive_words' => $positiveWords,
        'timeouts' => $timeouts,
        'processing' => [
            'global_timeout' => 120,
            'max_concurrent' => 25
        ]
    ];
    
    // Salvar configuração usando a função do config_ia.php
    $result = save_ia_config($config_data);
    
    if ($result !== false) {
        $response = ['success' => true, 'message' => 'Configuração salva com sucesso'];
    } else {
        $response = ['success' => false, 'error' => 'Erro ao salvar arquivo'];
    }
    
} catch (Exception $e) {
    $response = ['success' => false, 'error' => $e->getMessage()];
} catch (Error $e) {
    $response = ['success' => false, 'error' => 'Erro interno: ' . $e->getMessage()];
}

// Garantir que apenas JSON seja retornado
echo json_encode($response, JSON_UNESCAPED_UNICODE);
exit;
?>
